/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BigIntegerNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class GraphQLObjectMapper {
    @Autowired
    ApplicationContext ctx;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<Class<?>, Map<String, Field>> aliasFields;
    String graphQLObjectsPackage;

    public GraphQLObjectMapper(String graphQLObjectsPackage, Map<Class<?>, Map<String, Field>> aliasFields) {
        this.objectMapper.addHandler((DeserializationProblemHandler)new GraphQLDeserializationProblemHandler());
        this.graphQLObjectsPackage = graphQLObjectsPackage;
        this.aliasFields = aliasFields;
    }

    public Object getAliasValue(JsonParser parser, Field targetField, TreeNode value) throws IOException, GraphQLRequestExecutionException {
        if (value instanceof ArrayNode) {
            ArrayList<Object> list = new ArrayList<Object>(((ArrayNode)value).size());
            for (TreeNode o : (ArrayNode)value) {
                list.add(this.getAliasValue(parser, targetField, o));
            }
            return list;
        }
        if (value instanceof ObjectNode) {
            Class<?> clazz;
            String typename = ((TextNode)value.get("__typename")).asText();
            try {
                clazz = GraphqlClientUtils.graphqlClientUtils.getClass(this.graphQLObjectsPackage, typename, null);
            }
            catch (RuntimeException e) {
                throw new JsonMappingException((Closeable)parser, e.getMessage(), (Throwable)e);
            }
            return this.objectMapper.treeToValue(value, clazz);
        }
        if (value instanceof NullNode) {
            return null;
        }
        if (targetField != null && targetField.getType().isEnum()) {
            if (!(value instanceof TextNode)) {
                return new GraphQLRequestExecutionException("The '" + targetField + "' is an enum, so the encoded json should be a TextNode. But it's a '" + value.getClass().getName() + "'");
            }
            return Enum.valueOf(targetField.getType(), ((TextNode)value).textValue());
        }
        if (value instanceof BooleanNode) {
            return ((BooleanNode)value).booleanValue();
        }
        if (value instanceof DecimalNode) {
            return ((DecimalNode)value).decimalValue();
        }
        if (value instanceof DoubleNode) {
            return ((DoubleNode)value).doubleValue();
        }
        if (value instanceof FloatNode) {
            return ((FloatNode)value).asDouble();
        }
        if (value instanceof BigIntegerNode) {
            return ((BigIntegerNode)value).bigIntegerValue();
        }
        if (value instanceof IntNode) {
            return ((IntNode)value).intValue();
        }
        if (value instanceof LongNode) {
            return ((LongNode)value).longValue();
        }
        if (value instanceof ShortNode) {
            return ((ShortNode)value).shortValue();
        }
        if (value instanceof TextNode) {
            return ((TextNode)value).textValue();
        }
        throw new GraphQLRequestExecutionException("Non managed json type. This can happen in two cases: the value for this alias is a GraphQL custom scalar (in which case you should use the getAliasCustomScalarValue method) or a bug");
    }

    public Map<String, JsonNode> convertValue(JsonNode extensions, TypeReference<Map<String, JsonNode>> typeReference) {
        return (Map)this.objectMapper.convertValue((Object)extensions, typeReference);
    }

    public <T> T convertValue(Object o, Class<T> clazz) {
        return (T)this.objectMapper.convertValue(o, clazz);
    }

    public <T> T readValue(String msg, Class<T> subscriptionType) throws JsonMappingException, JsonProcessingException {
        return (T)this.objectMapper.readValue(msg, subscriptionType);
    }

    public JsonNode readTree(String content) throws JsonMappingException, JsonProcessingException {
        return this.objectMapper.readTree(content);
    }

    public <T> T treeToValue(TreeNode value, Class<T> clazz) throws JsonProcessingException {
        return (T)this.objectMapper.treeToValue(value, clazz);
    }

    public String writeValueAsString(Object o) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString(o);
    }

    public class GraphQLDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private Logger logger = LoggerFactory.getLogger(GraphQLDeserializationProblemHandler.class);

        public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser p, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
            Map aliases = null;
            Field targetField = null;
            JsonDeserialize jsonDeserialize = null;
            Object value = null;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Reading alias '" + propertyName + "' for " + beanOrClass.getClass().getName());
            }
            if (GraphQLObjectMapper.this.aliasFields != null) {
                aliases = (Map)GraphQLObjectMapper.this.aliasFields.get(beanOrClass.getClass());
            }
            if (aliases != null) {
                targetField = (Field)aliases.get(propertyName);
            }
            if (targetField != null) {
                jsonDeserialize = targetField.getAnnotation(JsonDeserialize.class);
            }
            try {
                if (jsonDeserialize != null) {
                    JsonDeserializer graphQLDeserializer = (JsonDeserializer)jsonDeserialize.using().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    value = graphQLDeserializer.deserialize(p, ctxt);
                } else {
                    value = GraphQLObjectMapper.this.getAliasValue(p, targetField, p.readValueAsTree());
                }
            }
            catch (GraphQLRequestExecutionException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            String methodName = "setAliasValue";
            try {
                Method setAliasValue = beanOrClass.getClass().getMethod(methodName, String.class, Object.class);
                setAliasValue.invoke(beanOrClass, propertyName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Could not find or invoke the method '" + methodName + "' in the " + beanOrClass.getClass().getName() + " class", e);
            }
            return true;
        }
    }
}

