/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.client.GraphQLTypeMapping;
import java.util.HashMap;
import java.util.Map;

public class GraphQLTypeMappingRegistry {
    private static Map<String, GraphQLTypeMapping> graphQLTypeMappings = new HashMap<String, GraphQLTypeMapping>();

    public static void registerGraphQLTypeMapping(GraphQLTypeMapping graphQLTypeMapping) {
        if (!graphQLTypeMappings.containsKey(graphQLTypeMapping.getSchemaName())) {
            graphQLTypeMappings.put(graphQLTypeMapping.getSchemaName(), graphQLTypeMapping);
        }
    }

    public static boolean isGraphQLTypeMappingRegistered(String schemaName) {
        return graphQLTypeMappings.containsKey(schemaName);
    }

    public static GraphQLTypeMapping getGraphQLTypeMapping(String schemaName) {
        GraphQLTypeMapping ret = graphQLTypeMappings.get(schemaName);
        if (ret == null) {
            throw new RuntimeException("The GraphQLTypeMapping for the schema '" + schemaName + "' has not been registered");
        }
        return ret;
    }

    public static Class<?> getJavaClass(String schemaName, String typeName) {
        return GraphQLTypeMappingRegistry.getGraphQLTypeMapping(schemaName).getJavaClass(typeName);
    }
}

