/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.response;

import graphql.GraphQLContext;
import graphql.execution.CoercedVariables;
import graphql.language.BooleanValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.GraphQLScalarType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

public abstract class AbstractCustomJacksonDeserializer<T>
extends StdDeserializer<T> {
    AbstractCustomJacksonDeserializer<?> itemDeserializer;
    final GraphQLScalarType graphQLScalarType;
    final boolean list;
    final Class<?> handledType;

    protected AbstractCustomJacksonDeserializer(Class<?> handledType, GraphQLScalarType graphQLScalarType) {
        this(null, false, handledType, graphQLScalarType);
    }

    protected AbstractCustomJacksonDeserializer(AbstractCustomJacksonDeserializer<?> itemDeserializer, boolean list, Class<?> handledType, GraphQLScalarType graphQLScalarType) {
        super(handledType);
        this.itemDeserializer = itemDeserializer;
        this.list = list;
        this.handledType = handledType;
        this.graphQLScalarType = graphQLScalarType;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws StreamReadException {
        BooleanValue value;
        if (p.currentToken().equals((Object)JsonToken.VALUE_NULL)) {
            return null;
        }
        if (this.list) {
            if (!p.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                throw new StreamReadException(p, "Found a " + p.currentToken().asString() + " token, but the current deserializer expects a list");
            }
            ArrayList<Object> returnedList = new ArrayList<Object>();
            while (!p.nextToken().equals((Object)JsonToken.END_ARRAY)) {
                if (p.currentToken().equals((Object)JsonToken.START_ARRAY)) {
                    if (this.itemDeserializer == null) {
                        throw new StreamReadException(p, "Found a " + p.currentToken().asString() + " JSON token, but the itemDeserializer is not defined. This JSON token can not be handled.");
                    }
                    if (!this.itemDeserializer.list) {
                        throw new StreamReadException(p, "Found a " + p.currentToken().asString() + " JSON token, but the itemDeserializer doesn't manage list. Hint: The number of embedded lists doesn't match the defined deserializer for the GraphQL field.");
                    }
                    returnedList.add(this.itemDeserializer.deserialize(p, ctxt));
                    continue;
                }
                if (this.itemDeserializer != null) {
                    if (p.currentToken().equals((Object)JsonToken.VALUE_NULL)) {
                        returnedList.add(null);
                        continue;
                    }
                    if (this.itemDeserializer.list) {
                        throw new StreamReadException(p, "Found a " + p.currentToken().asString() + " JSON token, but the itemDeserializer expects a list. Hint: the number of embedded lists doesn't match the defined deserializer for the GraphQL field.");
                    }
                    returnedList.add(this.itemDeserializer.deserialize(p, ctxt));
                    continue;
                }
                Object o = p.readValueAs(this.handledType);
                returnedList.add(o);
            }
            return (T)returnedList;
        }
        if (this.itemDeserializer != null) {
            return (T)this.itemDeserializer.deserialize(p, ctxt);
        }
        if (this.graphQLScalarType == null) {
            throw new StreamReadException(p, "Having to parse a " + p.currentToken() + ", but there is no graphQLScalarType defined");
        }
        switch (p.currentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                value = new BooleanValue(p.getBooleanValue());
                break;
            }
            case VALUE_NUMBER_FLOAT: {
                value = new FloatValue(p.getDecimalValue());
                break;
            }
            case VALUE_NUMBER_INT: {
                value = new IntValue(p.getBigIntegerValue());
                break;
            }
            case VALUE_STRING: {
                value = new StringValue(p.getString());
                break;
            }
            case VALUE_NULL: {
                value = null;
                break;
            }
            case START_OBJECT: {
                return (T)p.readValueAsTree();
            }
            default: {
                throw new StreamReadException(p, "Non managed JSON token: " + p.currentToken());
            }
        }
        if (value == null) {
            return null;
        }
        return (T)this.graphQLScalarType.getCoercing().parseLiteral((Value)value, new CoercedVariables(new HashMap()), GraphQLContext.getDefault(), Locale.getDefault());
    }
}

