/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.response;

import com.graphql_java_generator.client.response.Location;
import graphql.ErrorClassification;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import tools.jackson.core.JacksonException;
import tools.jackson.core.TreeNode;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.annotation.JsonDeserialize;

public class Error
implements GraphQLError {
    private static final long serialVersionUID = 1L;
    public String message;
    @JsonDeserialize(contentAs=Location.class)
    public List<Location> locations;
    public String description;
    public String validationErrorType;
    @JsonDeserialize(contentAs=String.class)
    public List<String> queryPath;
    public String errorType;
    public List<String> path;
    public JsonNode extensions;
    private Map<String, Object> extensionsAsMapOfObject = null;
    private Map<String, JsonNode> extensionsAsMapOfJsonNode = null;
    private ObjectMapper localObjectMapper = null;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.validationErrorType != null) {
            sb.append("[{").append(this.validationErrorType).append("}]");
        }
        if (this.errorType != null) {
            sb.append("{").append(this.errorType).append("}");
        }
        sb.append("{").append(this.message).append("}");
        if (this.queryPath != null) {
            sb.append(" path: {").append(this.queryPath.stream().collect(Collectors.joining(","))).append("}");
        }
        if (this.locations != null) {
            sb.append(" - locations: {").append(this.locations.stream().map(Object::toString).collect(Collectors.joining(","))).append("}");
        }
        if (this.description != null) {
            sb.append(" - ({").append(this.description).append("})");
        }
        return sb.toString();
    }

    public JsonNode getExtensionsAsJsonNode() {
        return this.extensions;
    }

    public void setExtensions(JsonNode extensions) {
        this.extensions = extensions;
    }

    public Map<String, Object> getExtensions() {
        if (this.extensionsAsMapOfObject == null) {
            this.extensionsAsMapOfObject = (Map)this.getMapper().convertValue((Object)this.extensions, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return this.extensionsAsMapOfObject;
    }

    public Map<String, JsonNode> getExtensionsAsMapOfJsonNode() {
        if (this.extensionsAsMapOfJsonNode == null) {
            this.extensionsAsMapOfJsonNode = (Map)this.getMapper().convertValue((Object)this.extensions, (TypeReference)new TypeReference<Map<String, JsonNode>>(){});
        }
        return this.extensionsAsMapOfJsonNode;
    }

    public Map<String, String> getExtensionsAsMapStringString() {
        this.getExtensionsAsMapOfJsonNode();
        HashMap<String, String> extensionsAsMapStringString = new HashMap<String, String>();
        for (String key : this.extensionsAsMapOfJsonNode.keySet()) {
            extensionsAsMapStringString.put(key, this.extensionsAsMapOfJsonNode.get(key).toString());
        }
        return extensionsAsMapStringString;
    }

    public <T> T getExtensionsField(String key, Class<T> t) throws JacksonException {
        JsonNode node = this.getExtensionsAsMapOfJsonNode().get(key);
        return (T)(node == null ? null : this.getMapper().treeToValue((TreeNode)node, t));
    }

    private ObjectMapper getMapper() {
        if (this.localObjectMapper == null) {
            this.localObjectMapper = new ObjectMapper();
        }
        return this.localObjectMapper;
    }

    public String getMessage() {
        return this.message;
    }

    public List<SourceLocation> getLocations() {
        return this.locations == null ? null : this.locations.stream().map(l -> new SourceLocation(l.line, l.column, l.sourceName)).collect(Collectors.toList());
    }

    public ErrorClassification getErrorType() {
        return new ErrorClassification(){

            public Object toSpecification(GraphQLError error) {
                return Error.this.errorType;
            }
        };
    }
}

