/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.spring.client;

import com.graphql_java_generator.client.OAuthTokenExtractor;
import com.graphql_java_generator.client.QueryExecutor;
import com.graphql_java_generator.client.QueryExecutorSpringReactiveImpl;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import reactor.netty.http.client.HttpClient;

@Configuration
public class GraphQLAutoConfiguration {
    @Value(value="${graphql.endpoint.url}")
    private String graphqlEndpoint;
    @Value(value="${graphql.endpoint.subscriptionUrl}")
    private String graphqlSubscriptionEndpoint;

    @Bean
    String graphqlEndpoint() {
        return this.graphqlEndpoint;
    }

    @Bean
    String graphqlSubscriptionEndpoint() {
        return this.graphqlSubscriptionEndpoint;
    }

    @Bean
    @ConditionalOnMissingBean
    QueryExecutor queryExecutor(String graphqlEndpoint, @Autowired(required=false) String graphqlSubscriptionEndpoint, WebClient webClient, @Autowired(required=false) WebSocketClient webSocketClient, @Autowired(required=false) ServerOAuth2AuthorizedClientExchangeFilterFunction serverOAuth2AuthorizedClientExchangeFilterFunction, @Autowired(required=false) OAuthTokenExtractor oAuthTokenRetriever) {
        return new QueryExecutorSpringReactiveImpl(graphqlEndpoint, graphqlSubscriptionEndpoint, webClient, webSocketClient, serverOAuth2AuthorizedClientExchangeFilterFunction, oAuthTokenRetriever);
    }

    @Bean
    @ConditionalOnMissingBean
    public WebClient webClient(String graphqlEndpoint, @Autowired(required=false) HttpClient httpClient, @Autowired(required=false) ServerOAuth2AuthorizedClientExchangeFilterFunction oauthFilter) {
        WebClient.Builder webClientBuilder = WebClient.builder().baseUrl(graphqlEndpoint).defaultHeader("Content-Type", new String[]{"application/json"}).defaultUriVariables(Collections.singletonMap("url", graphqlEndpoint));
        if (httpClient != null) {
            webClientBuilder.clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient));
        }
        if (oauthFilter != null) {
            webClientBuilder.filter((ExchangeFilterFunction)oauthFilter);
        }
        return webClientBuilder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSocketClient webSocketClient(@Autowired(required=false) HttpClient httpClient) {
        if (httpClient == null) {
            return new ReactorNettyWebSocketClient(HttpClient.create());
        }
        return new ReactorNettyWebSocketClient(httpClient);
    }
}

