/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.graphql_java_generator.annotation.GraphQLInputType;
import com.graphql_java_generator.annotation.GraphQLInterfaceType;
import com.graphql_java_generator.annotation.GraphQLObjectType;
import com.graphql_java_generator.annotation.GraphQLQuery;
import com.graphql_java_generator.annotation.GraphQLUnionType;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.directive.Directive;
import com.graphql_java_generator.client.request.AppliedGlobalFragment;
import com.graphql_java_generator.client.request.Fragment;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.QueryTokenizer;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryField {
    private static Logger logger = LoggerFactory.getLogger(QueryField.class);
    GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils;
    GraphqlClientUtils graphqlClientUtils = GraphqlClientUtils.graphqlClientUtils;
    Class<?> owningClazz;
    final Class<?> clazz;
    final String name;
    final String alias;
    final String packageName;
    Boolean scalar = null;
    Boolean queryLevel = null;
    List<InputParameter> inputParameters = new ArrayList<InputParameter>();
    List<Directive> directives = new ArrayList<Directive>();
    List<AppliedGlobalFragment> fragments = new ArrayList<AppliedGlobalFragment>();
    List<Fragment> inlineFragments = new ArrayList<Fragment>();
    List<QueryField> fields = new ArrayList<QueryField>();

    public QueryField(Class<?> owningClass, String fieldName, String fieldAlias) throws GraphQLRequestPreparationException {
        this.graphqlClientUtils.checkName(fieldName);
        if (fieldAlias != null) {
            this.graphqlClientUtils.checkName(fieldAlias);
        }
        this.owningClazz = owningClass;
        this.clazz = this.graphqlClientUtils.checkFieldOfGraphQLType(fieldName, null, owningClass);
        this.name = fieldName;
        this.alias = fieldAlias;
        this.packageName = owningClass.getPackage().getName();
    }

    public QueryField(Class<?> owningClass, String fieldName) throws GraphQLRequestPreparationException {
        this(owningClass, fieldName, null);
    }

    QueryField(Class<?> clazz) throws GraphQLRequestPreparationException {
        this.owningClazz = null;
        this.clazz = clazz;
        this.name = null;
        this.alias = null;
        this.packageName = clazz.getPackage().getName();
    }

    public void readTokenizerForResponseDefinition(QueryTokenizer qt, Map<Class<?>, Map<String, Field>> aliasFields) throws GraphQLRequestPreparationException {
        QueryField currentField = null;
        block14: while (qt.hasMoreTokens()) {
            String token;
            switch (token = qt.nextToken()) {
                case "@": {
                    currentField.directives.add(new Directive(qt));
                    continue block14;
                }
                case "(": {
                    if (currentField != null) {
                        currentField.inputParameters = InputParameter.readTokenizerForInputParameters(qt, null, currentField.owningClazz, currentField.name);
                        continue block14;
                    }
                    throw new GraphQLRequestPreparationException("The given query has a parentesis '(' not preceded by a field name (error while reading field '" + this.name + "'");
                }
                case "{": {
                    if (currentField == null) {
                        throw new GraphQLRequestPreparationException("The given query has two '{', one after another (error while reading field '" + this.name + "')");
                    }
                    if (currentField.clazz == null) {
                        throw new GraphQLRequestPreparationException("Starting reading definition of field '" + currentField.name + "' of class '" + this.owningClazz.getName() + "', but the owningClass is not set");
                    }
                    if (currentField.fields.size() > 0) {
                        throw new GraphQLRequestPreparationException("The given query contains a '{' not preceded by a fieldname, after field '" + currentField.name + "' while reading '" + this.name + "'");
                    }
                    currentField.readTokenizerForResponseDefinition(qt, aliasFields);
                    currentField = null;
                    continue block14;
                }
                case "...": {
                    this.inlineFragments.add(new Fragment(qt, aliasFields, this.packageName, true, this.clazz));
                    continue block14;
                }
                case "}": {
                    return;
                }
            }
            if (token.startsWith("...")) {
                this.fragments.add(new AppliedGlobalFragment(token, qt));
                logger.trace("Found fragment {} for field {}", (Object)token, (Object)this.name);
                continue;
            }
            if (qt.checkNextToken(":")) {
                String tokenAlias = token;
                token = qt.nextToken();
                token = qt.nextToken();
                currentField = new QueryField(this.clazz, token, tokenAlias);
                this.addAlias(this.clazz, tokenAlias, token, aliasFields);
            } else {
                currentField = new QueryField(this.clazz, token);
            }
            if (this.getField(currentField.alias, currentField.name) != null) {
                throw new GraphQLRequestPreparationException("The field '" + currentField.name + "' exists twice in the field list for the " + this.clazz.getSimpleName() + " type");
            }
            this.fields.add(currentField);
        }
        throw new GraphQLRequestPreparationException("The field '" + this.name + "' has a non finished list of fields (it lacks the finishing '}') while reading '" + this.name + "'");
    }

    void addAlias(Class<?> clazzParam, String aliasName, String fieldName, Map<Class<?>, Map<String, Field>> aliasFields) throws GraphQLRequestPreparationException {
        if (aliasFields == null) {
            throw new NullPointerException("[Internal Error] aliasFields may not be null");
        }
        this.graphqlClientUtils.checkName(aliasName);
        if (clazzParam.isInterface()) {
            JsonSubTypes jsonSubTypes = clazzParam.getAnnotation(JsonSubTypes.class);
            for (JsonSubTypes.Type type : jsonSubTypes.value()) {
                this.addAlias(type.value(), aliasName, fieldName, aliasFields);
            }
        } else {
            Field field;
            Map<String, Field> aliases = aliasFields.get(clazzParam);
            if (aliases == null) {
                aliases = new HashMap<String, Field>();
                aliasFields.put(clazzParam, aliases);
            }
            try {
                field = clazzParam.getDeclaredField(this.graphqlUtils.getJavaName(fieldName));
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new GraphQLRequestPreparationException(e.getClass().getSimpleName() + ": " + e.getMessage() + " (while looking for the field '" + this.graphqlUtils.getJavaName(fieldName) + "' of '" + clazzParam.getName() + "')", e);
            }
            if (aliases.get(aliasName) != null) {
                if (!field.equals(aliases.get(aliasName))) {
                    throw new GraphQLRequestPreparationException("For proper Java deserialization, the same alias name may not be used two times for two different fields. But the alias '" + aliasName + "' is defined for the class '" + clazzParam.getName() + "' (or one of its interfaces) for the fields '" + fieldName + "' and '" + aliases.get(aliasName).getName() + "'");
                }
            } else {
                aliases.put(aliasName, field);
            }
        }
    }

    public void appendToGraphQLRequests(StringBuilder sb, Map<String, Object> parameters, boolean appendName) throws GraphQLRequestExecutionException {
        if (appendName) {
            if (this.alias == null) {
                sb.append(this.name);
            } else {
                sb.append(this.alias).append(":").append(this.name);
            }
            InputParameter.appendInputParametersToGraphQLRequests(false, sb, this.inputParameters, parameters);
        }
        for (Directive d : this.directives) {
            d.appendToGraphQLRequests(sb, parameters);
        }
        boolean appendSpaceLocal = false;
        String unionName = this.getUnionName();
        if (this.fields.size() > 0 || this.fragments.size() > 0 || this.inlineFragments.size() > 0 || unionName != null) {
            logger.debug("Appending ReponseDef content for field " + this.name + " of type " + this.clazz.getSimpleName());
            sb.append("{");
            if (unionName != null) {
                sb.append("... on ");
                sb.append(unionName);
                sb.append("{__typename}");
                appendSpaceLocal = true;
            }
            for (QueryField queryField : this.fields) {
                if (appendSpaceLocal) {
                    sb.append(" ");
                }
                queryField.appendToGraphQLRequests(sb, parameters, true);
                appendSpaceLocal = true;
            }
            for (AppliedGlobalFragment appliedGlobalFragment : this.fragments) {
                if (appendSpaceLocal) {
                    sb.append(" ");
                }
                appliedGlobalFragment.appendToGraphQLRequests(sb, parameters);
                appendSpaceLocal = true;
            }
            for (Fragment fragment : this.inlineFragments) {
                if (appendSpaceLocal) {
                    sb.append(" ");
                }
                sb.append("...");
                fragment.appendToGraphQLRequests(sb, parameters);
                appendSpaceLocal = true;
            }
            sb.append("}");
        }
    }

    private String getUnionName() {
        GraphQLUnionType graphQLUnionType = this.clazz.getAnnotation(GraphQLUnionType.class);
        return graphQLUnionType == null ? null : graphQLUnionType.value();
    }

    void addTypenameFields() throws GraphQLRequestPreparationException {
        if (!this.isScalar()) {
            if (this.inlineFragments.size() > 0) {
                for (Fragment fragment : this.inlineFragments) {
                    fragment.addTypenameFields();
                }
            } else if (this.fragments.size() == 0) {
                QueryField __typename = null;
                for (QueryField f : this.fields) {
                    if (f.name.equals("__typename")) {
                        __typename = f;
                        break;
                    }
                    f.addTypenameFields();
                }
                if (!this.isQueryLevel() && __typename == null) {
                    __typename = new QueryField(this.clazz, "__typename");
                    this.fields.add(__typename);
                }
            }
            for (QueryField queryField : this.fields) {
                queryField.addTypenameFields();
            }
        }
    }

    public boolean isScalar() throws GraphQLRequestPreparationException {
        if (this.scalar == null) {
            GraphQLInputType graphQLInputType = this.clazz.getAnnotation(GraphQLInputType.class);
            GraphQLInterfaceType graphQLInterfaceType = this.clazz.getAnnotation(GraphQLInterfaceType.class);
            GraphQLObjectType graphQLObjectType = this.clazz.getAnnotation(GraphQLObjectType.class);
            GraphQLQuery graphQLQuery = this.clazz.getAnnotation(GraphQLQuery.class);
            GraphQLUnionType graphQLUnionType = this.clazz.getAnnotation(GraphQLUnionType.class);
            this.scalar = graphQLInputType == null && graphQLInterfaceType == null && graphQLObjectType == null && graphQLQuery == null && graphQLUnionType == null;
        }
        return this.scalar;
    }

    public boolean isQueryLevel() {
        if (this.queryLevel == null) {
            this.queryLevel = this.name != null && (this.name.equals("data") || this.name.equals("query") || this.name.equals("mutation") || this.name.equals("subscription"));
        }
        return this.queryLevel;
    }

    QueryField getField(String aliasParam, String nameParam) {
        String searchedString = aliasParam != null ? aliasParam : nameParam;
        for (QueryField f : this.fields) {
            if ((f.alias == null || !f.alias.equals(searchedString)) && (f.alias != null || !f.name.equals(searchedString))) continue;
            return f;
        }
        return null;
    }

    public List<QueryField> getFields() {
        return this.fields;
    }

    public Class<?> getOwningClazz() {
        return this.owningClazz;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }
}

