/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.server.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphqlErrorBuilder;
import graphql.execution.instrumentation.ChainedInstrumentation;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.tracing.TracingInstrumentation;
import graphql.schema.GraphQLSchema;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.SubProtocolCapable;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class GraphQlWebSocketHandler
extends TextWebSocketHandler
implements SubProtocolCapable {
    private static final Logger log = LoggerFactory.getLogger(GraphQlWebSocketHandler.class);
    private static final List<String> SUB_PROTOCOL_LIST = Arrays.asList("graphql-transport-ws", "subscriptions-transport-ws");
    private final Duration initTimeoutDuration = Duration.ofMillis(30000L);
    private final Map<String, SessionState> sessionInfoMap = new ConcurrentHashMap<String, SessionState>();
    ObjectMapper objectMapper = new ObjectMapper();
    GraphQL graphQL;

    public GraphQlWebSocketHandler(GraphQLSchema graphQLSchema) {
        ChainedInstrumentation instrumentation = new ChainedInstrumentation(Collections.singletonList(new TracingInstrumentation()));
        this.graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).instrumentation((Instrumentation)instrumentation).build();
    }

    public List<String> getSubProtocols() {
        return SUB_PROTOCOL_LIST;
    }

    public void afterConnectionEstablished(WebSocketSession session) {
        if (log.isTraceEnabled()) {
            log.trace("Executing 'afterConnectionEstablished' for session " + session.getId() + ", with acceptedProtocol=" + session.getAcceptedProtocol());
        }
        if ("subscriptions-transport-ws".equalsIgnoreCase(session.getAcceptedProtocol())) {
            if (log.isTraceEnabled()) {
                log.trace("apollographql/subscriptions-transport-ws is not supported, nor maintained. Please, use https://github.com/enisdenjo/graphql-ws.");
            }
            GraphQlStatus.closeSession(session, GraphQlStatus.INVALID_MESSAGE_STATUS);
            return;
        }
        SessionState sessionState = new SessionState(session.getId());
        this.sessionInfoMap.put(session.getId(), sessionState);
        if (log.isTraceEnabled()) {
            log.trace("The session " + session.getId() + " has been registered");
        }
        Mono.delay((Duration)this.initTimeoutDuration).then(Mono.fromRunnable(() -> {
            if (sessionState.isConnectionInitNotProcessed()) {
                log.trace("Timeout ({}s) while waiting for the connection initialization", (Object)this.initTimeoutDuration.getSeconds());
                GraphQlStatus.closeSession(session, GraphQlStatus.INIT_TIMEOUT_STATUS);
            }
        })).subscribe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTextMessage(WebSocketSession session, TextMessage message) throws Exception {
        Map map = (Map)this.objectMapper.readValue((String)message.getPayload(), HashMap.class);
        String id = (String)map.get("id");
        String type = (String)map.get("type");
        MessageType messageType = MessageType.resolve(type);
        if (messageType == null) {
            GraphQlStatus.closeSession(session, GraphQlStatus.INVALID_MESSAGE_STATUS);
            return;
        }
        SessionState sessionState = this.getSessionInfo(session);
        switch (messageType) {
            case CONNECTION_INIT: {
                log.trace("Received 'connection_init' for web socket {}", (Object)session);
                if (sessionState.setConnectionInitProcessed()) {
                    GraphQlStatus.closeSession(session, GraphQlStatus.TOO_MANY_INIT_REQUESTS_STATUS);
                    return;
                }
                TextMessage outputMessage = this.encode(null, MessageType.CONNECTION_ACK, null);
                WebSocketSession webSocketSession = session;
                synchronized (webSocketSession) {
                    session.sendMessage((WebSocketMessage)outputMessage);
                }
                return;
            }
            case START: 
            case SUBSCRIBE: {
                log.trace("Received 'subscribe' for operation id {} on web socket {} ({})", new Object[]{id, session, map});
                Map<String, Object> request = this.getPayload(map);
                if (sessionState.isConnectionInitNotProcessed()) {
                    GraphQlStatus.closeSession(session, GraphQlStatus.UNAUTHORIZED_STATUS);
                    return;
                }
                if (id == null) {
                    GraphQlStatus.closeSession(session, GraphQlStatus.INVALID_MESSAGE_STATUS);
                    return;
                }
                URI uri = session.getUri();
                Assert.notNull((Object)uri, (String)"Expected handshake url");
                HttpHeaders headers = session.getHandshakeHeaders();
                this.manageSubscribeMessage(uri, headers, request, id, session);
                return;
            }
            case COMPLETE: {
                this.manageCompleteMessage(session, id, sessionState);
                return;
            }
        }
        GraphQlStatus.closeSession(session, GraphQlStatus.INVALID_MESSAGE_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void manageSubscribeMessage(URI uri, HttpHeaders headers, Map<String, Object> payload, final String id, final WebSocketSession session) throws IOException {
        String query = payload.get("query").toString();
        Object operationName = payload.get("operationName");
        Map variables = (Map)payload.get("variables");
        Map extensions = (Map)payload.get("extensions");
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).variables(variables == null ? new HashMap() : variables).operationName(operationName == null ? null : operationName.toString()).extensions(extensions == null ? new HashMap() : extensions).build();
        ExecutionResult executionResult = this.graphQL.execute(executionInput);
        if (executionResult.getErrors() != null && executionResult.getErrors().size() > 0) {
            try {
                Object errors = executionResult.toSpecification().get("errors");
                log.trace("Sending 'error' message for operation {}: {}", (Object)id, errors);
                WebSocketSession webSocketSession = session;
                synchronized (webSocketSession) {
                    session.sendMessage((WebSocketMessage)this.encode(id, MessageType.ERROR, errors));
                }
            }
            catch (IOException e) {
                log.error("Could not send error message for subscription {} due to {}: {}", new Object[]{id, e.getClass().getSimpleName(), e.getMessage()});
            }
        } else if (executionResult.getData() instanceof Publisher) {
            Publisher publisher = (Publisher)executionResult.getData();
            publisher.subscribe((Subscriber)new Subscriber<ExecutionResult>(){
                private String uniqueOperationId;
                private Subscription subscription;
                {
                    this.uniqueOperationId = id;
                }

                public synchronized void onSubscribe(Subscription s) {
                    this.subscription = s;
                    log.trace("Executing onSubscribe for subscription of id {} in Web Socket Session {} (the reactive flux subscription is {})", new Object[]{id, session.getId(), s});
                    Subscription prev = GraphQlWebSocketHandler.this.getSessionInfo(session).getSubscriptions().putIfAbsent(id, this.subscription);
                    if (prev != null) {
                        throw new SubscriptionExistsException();
                    }
                    this.subscription.request(1L);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public synchronized void onNext(ExecutionResult er) {
                    try {
                        TextMessage msg = GraphQlWebSocketHandler.this.encode(this.uniqueOperationId, MessageType.NEXT, er.toSpecification());
                        log.trace("Sending new notification for subscription {}, on Web Socket Session {}: {}", new Object[]{this.uniqueOperationId, session.getId(), msg.getPayload()});
                        WebSocketSession webSocketSession = session;
                        synchronized (webSocketSession) {
                            session.sendMessage((WebSocketMessage)msg);
                        }
                        this.subscription.request(1L);
                    }
                    catch (IOException e) {
                        this.onError(e);
                    }
                }

                public synchronized void onError(Throwable t) {
                    log.error("Received onError for Subscription id={}, on web socket {}. The exception is {}", new Object[]{id, session.getId(), t});
                    if (t instanceof SubscriptionExistsException) {
                        CloseStatus status = new CloseStatus(4409, "Subscriber for " + id + " already exists");
                        GraphQlStatus.closeSession(session, status);
                    } else {
                        ErrorType errorType = ErrorType.DataFetchingException;
                        String message = t.getMessage();
                        Map errorMap = GraphqlErrorBuilder.newError().errorType((ErrorClassification)errorType).message(message, new Object[0]).build().toSpecification();
                        List<Map> errors = Arrays.asList(errorMap);
                        try {
                            session.sendMessage((WebSocketMessage)GraphQlWebSocketHandler.this.encode(this.uniqueOperationId, MessageType.ERROR, errors));
                        }
                        catch (IOException e) {
                            log.error("Could not send error message for subscription {} due to {}: {}", new Object[]{id, e.getClass().getSimpleName(), e.getMessage()});
                        }
                    }
                }

                public synchronized void onComplete() {
                    log.debug("Received onComplete for Subscription id={} on web socket {}", (Object)id, (Object)session.getId());
                    try {
                        session.sendMessage((WebSocketMessage)GraphQlWebSocketHandler.this.encode(this.uniqueOperationId, MessageType.COMPLETE, null));
                        Subscription sub = GraphQlWebSocketHandler.this.getSessionInfo(session).getSubscriptions().get(id);
                        if (sub != null) {
                            log.trace("Removing reactive flux subscription is {}, after onComplete", (Object)sub);
                            GraphQlWebSocketHandler.this.getSessionInfo(session).getSubscriptions().remove(id);
                            sub.cancel();
                        }
                    }
                    catch (IOException e) {
                        log.error("Unable to close websocket session", (Throwable)e);
                    }
                }
            });
        } else {
            if (executionResult.getData() instanceof Map) {
                TextMessage msg = this.encode(id, MessageType.NEXT, executionResult.toSpecification());
                log.trace("Sending response for query or mutation {}, on Web Socket Session {}: {}", new Object[]{id, session.getId(), msg.getPayload()});
                WebSocketSession webSocketSession = session;
                synchronized (webSocketSession) {
                    session.sendMessage((WebSocketMessage)msg);
                }
            }
            TextMessage msg = this.encode(id, MessageType.ERROR, executionResult.toSpecification());
            log.trace("Sending error for query or mutation {}, on Web Socket Session {}: {}", new Object[]{id, session.getId(), msg.getPayload()});
            WebSocketSession webSocketSession = session;
            synchronized (webSocketSession) {
                session.sendMessage((WebSocketMessage)msg);
            }
        }
    }

    private synchronized void manageCompleteMessage(WebSocketSession session, String id, SessionState sessionState) {
        Subscription subscription;
        log.trace("Received 'complete' for operation id {} on web socket {}", (Object)id, (Object)session);
        if (id != null && (subscription = sessionState.getSubscriptions().remove(id)) != null) {
            log.trace("Cancelling subscription for operation id {} on web socket {} (the reactive flux subscription is {})", new Object[]{id, session, subscription});
            subscription.cancel();
        }
    }

    private Map<String, Object> getPayload(Map<String, Object> message) {
        Object payload = message.get("payload");
        Assert.notNull((Object)payload, (String)("No payload in message: " + message));
        Assert.isTrue((boolean)(payload instanceof Map), (String)("The payload should be a Map, but is a " + payload.getClass().getName() + ", in message: " + message));
        return (Map)payload;
    }

    private SessionState getSessionInfo(WebSocketSession session) {
        SessionState info = this.sessionInfoMap.get(session.getId());
        Assert.notNull((Object)info, (String)("No SessionInfo for " + session));
        return info;
    }

    private <T> TextMessage encode(@Nullable String id, MessageType messageType, @Nullable Object payload) {
        HashMap<String, Object> payloadMap = new HashMap<String, Object>(3);
        payloadMap.put("type", messageType.getType());
        if (id != null) {
            payloadMap.put("id", id);
        }
        if (payload != null) {
            payloadMap.put("payload", payload);
        }
        try {
            return new TextMessage((CharSequence)this.objectMapper.writeValueAsString(payloadMap));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to write " + payloadMap + " as JSON", ex);
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) {
        SessionState info;
        if (log.isTraceEnabled()) {
            log.trace("Executing 'handleTransportError' for session " + session.getId() + " of exception: " + exception.getClass().getSimpleName() + ": " + exception.getMessage());
        }
        if ((info = this.sessionInfoMap.remove(session.getId())) != null) {
            info.dispose();
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
        SessionState info;
        if (log.isTraceEnabled()) {
            log.trace("Executing 'afterConnectionClosed' for session " + session.getId() + ", with closeStatus=" + closeStatus);
        }
        if ((info = this.sessionInfoMap.remove(session.getId())) != null) {
            info.dispose();
        }
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    private static enum MessageType {
        CONNECTION_INIT("connection_init"),
        CONNECTION_ACK("connection_ack"),
        SUBSCRIBE("subscribe"),
        NEXT("next"),
        ERROR("error"),
        COMPLETE("complete"),
        START("start");

        private static final Map<String, MessageType> messageTypes;
        private final String type;

        private MessageType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        @Nullable
        public static MessageType resolve(@Nullable String type) {
            return type != null ? messageTypes.get(type) : null;
        }

        static {
            messageTypes = new HashMap<String, MessageType>(6);
            for (MessageType messageType : MessageType.values()) {
                messageTypes.put(messageType.getType(), messageType);
            }
        }
    }

    private static class SessionState {
        private boolean connectionInitProcessed;
        private final Map<String, Subscription> subscriptions = new ConcurrentHashMap<String, Subscription>();
        private final Scheduler scheduler;

        SessionState(String sessionId) {
            this.scheduler = Schedulers.newSingle((String)("GraphQL-WsSession-" + sessionId));
        }

        boolean isConnectionInitNotProcessed() {
            return !this.connectionInitProcessed;
        }

        synchronized boolean setConnectionInitProcessed() {
            boolean previousValue = this.connectionInitProcessed;
            this.connectionInitProcessed = true;
            return previousValue;
        }

        Map<String, Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        void dispose() {
            for (Map.Entry<String, Subscription> entry : this.subscriptions.entrySet()) {
                try {
                    entry.getValue().cancel();
                }
                catch (Throwable throwable) {}
            }
            this.subscriptions.clear();
            this.scheduler.dispose();
        }
    }

    private static class GraphQlStatus {
        private static final CloseStatus INVALID_MESSAGE_STATUS = new CloseStatus(4400, "Invalid message");
        private static final CloseStatus UNAUTHORIZED_STATUS = new CloseStatus(4401, "Unauthorized");
        private static final CloseStatus INIT_TIMEOUT_STATUS = new CloseStatus(4408, "Connection initialisation timeout");
        private static final CloseStatus TOO_MANY_INIT_REQUESTS_STATUS = new CloseStatus(4429, "Too many initialisation requests");

        private GraphQlStatus() {
        }

        static void closeSession(WebSocketSession session, CloseStatus status) {
            block2: {
                try {
                    session.close(status);
                }
                catch (IOException ex) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug("Error while closing session with status: " + status, (Throwable)ex);
                }
            }
        }
    }

    private static class SubscriptionExistsException
    extends RuntimeException {
        private SubscriptionExistsException() {
        }
    }
}

