/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.Scalars;
import graphql.TypeResolutionEnvironment;
import graphql.annotations.BatchedMethodDataFetcher;
import graphql.annotations.BatchedTypeFunction;
import graphql.annotations.Connection;
import graphql.annotations.DefaultTypeFunction;
import graphql.annotations.GraphQLAnnotationsException;
import graphql.annotations.GraphQLAnnotationsProcessor;
import graphql.annotations.GraphQLBatched;
import graphql.annotations.GraphQLConnection;
import graphql.annotations.GraphQLDataFetcher;
import graphql.annotations.GraphQLDefaultValue;
import graphql.annotations.GraphQLDeprecate;
import graphql.annotations.GraphQLDescription;
import graphql.annotations.GraphQLField;
import graphql.annotations.GraphQLName;
import graphql.annotations.GraphQLObjectTypeWrapper;
import graphql.annotations.GraphQLRelayMutation;
import graphql.annotations.GraphQLType;
import graphql.annotations.GraphQLTypeResolver;
import graphql.annotations.GraphQLUnion;
import graphql.annotations.MethodDataFetcher;
import graphql.annotations.ReflectionKit;
import graphql.annotations.RelayMutationMethodDataFetcher;
import graphql.annotations.TypeFunction;
import graphql.annotations.util.NamingKit;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import graphql.schema.FieldDataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.TypeResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class GraphQLAnnotations
implements GraphQLAnnotationsProcessor {
    private static final Relay RELAY_TYPES = new Relay();
    private Map<String, graphql.schema.GraphQLType> typeRegistry = new HashMap<String, graphql.schema.GraphQLType>();
    private final Stack<String> processing = new Stack();
    public static GraphQLAnnotations instance = new GraphQLAnnotations();
    protected TypeFunction defaultTypeFunction;

    public GraphQLAnnotations() {
        this(new DefaultTypeFunction());
        ((DefaultTypeFunction)this.defaultTypeFunction).setAnnotationsProcessor(this);
    }

    public GraphQLAnnotations(TypeFunction defaultTypeFunction) {
        this.defaultTypeFunction = defaultTypeFunction;
    }

    public static GraphQLAnnotations getInstance() {
        return instance;
    }

    @Override
    public graphql.schema.GraphQLType getInterface(Class<?> iface) throws GraphQLAnnotationsException {
        String typeName = this.getTypeName(iface);
        Object type = this.typeRegistry.get(typeName);
        if (type != null) {
            return type;
        }
        type = iface.getAnnotation(GraphQLUnion.class) != null ? this.getUnionBuilder(iface).build() : (!iface.isAnnotationPresent(GraphQLTypeResolver.class) ? this.getObject(iface) : this.getIfaceBuilder(iface).build());
        this.typeRegistry.put(typeName, (graphql.schema.GraphQLType)type);
        return type;
    }

    public static graphql.schema.GraphQLType iface(Class<?> iface) throws GraphQLAnnotationsException {
        return GraphQLAnnotations.getInstance().getInterface(iface);
    }

    @Override
    public GraphQLUnionType.Builder getUnionBuilder(Class<?> iface) throws GraphQLAnnotationsException, IllegalArgumentException {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        GraphQLUnion unionAnnotation = iface.getAnnotation(GraphQLUnion.class);
        builder.name(this.getTypeName(iface));
        GraphQLDescription description = iface.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        GraphQLType typeAnnotation = iface.getAnnotation(GraphQLType.class);
        TypeFunction typeFunction = this.defaultTypeFunction;
        if (typeAnnotation != null) {
            typeFunction = ReflectionKit.newInstance(typeAnnotation.value());
        }
        final TypeFunction finalTypeFunction = typeFunction;
        Arrays.asList(unionAnnotation.possibleTypes()).stream().map(new Function<Class<?>, graphql.schema.GraphQLType>(){

            @Override
            public graphql.schema.GraphQLType apply(Class<?> aClass) {
                return finalTypeFunction.buildType(aClass, null);
            }
        }).map(v -> (GraphQLObjectType)v).forEach(arg_0 -> ((GraphQLUnionType.Builder)builder).possibleType(arg_0));
        builder.typeResolver((TypeResolver)new UnionTypeResolver(unionAnnotation.possibleTypes()));
        return builder;
    }

    public static GraphQLUnionType.Builder unionBuilder(Class<?> iface) throws GraphQLAnnotationsException {
        return GraphQLAnnotations.getInstance().getUnionBuilder(iface);
    }

    public String getTypeName(Class<?> objectClass) {
        GraphQLName name = objectClass.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName(name == null ? objectClass.getSimpleName() : name.value());
    }

    @Override
    public GraphQLInterfaceType.Builder getIfaceBuilder(Class<?> iface) throws GraphQLAnnotationsException, IllegalArgumentException {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        GraphQLInterfaceType.Builder builder = GraphQLInterfaceType.newInterface();
        builder.name(this.getTypeName(iface));
        GraphQLDescription description = iface.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        for (Method method : this.getOrderedMethods(iface)) {
            boolean valid = !Modifier.isStatic(method.getModifiers()) && method.getAnnotation(GraphQLField.class) != null;
            if (!valid) continue;
            builder.field(this.getField(method));
        }
        GraphQLTypeResolver typeResolver = iface.getAnnotation(GraphQLTypeResolver.class);
        builder.typeResolver(ReflectionKit.newInstance(typeResolver.value()));
        return builder;
    }

    public static GraphQLInterfaceType.Builder ifaceBuilder(Class<?> iface) throws GraphQLAnnotationsException, IllegalAccessException {
        return GraphQLAnnotations.getInstance().getIfaceBuilder(iface);
    }

    private static Boolean isGraphQLField(AnnotatedElement element) {
        GraphQLField annotation = element.getAnnotation(GraphQLField.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    private boolean breadthFirstSearch(Method method) {
        LinkedList queue = new LinkedList();
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        queue.add(method.getDeclaringClass());
        do {
            Boolean gqf;
            Class cls = (Class)queue.remove(0);
            try {
                method = cls.getDeclaredMethod(methodName, parameterTypes);
                gqf = GraphQLAnnotations.isGraphQLField(method);
                if (gqf != null) {
                    return gqf;
                }
            }
            catch (NoSuchMethodException gqf2) {
                // empty catch block
            }
            gqf = GraphQLAnnotations.isGraphQLField(cls);
            if (gqf != null) {
                return gqf;
            }
            for (Class<?> iface : cls.getInterfaces()) {
                queue.add(iface);
            }
            Class nxt = cls.getSuperclass();
            if (nxt == null) continue;
            queue.add(nxt);
        } while (!queue.isEmpty());
        return false;
    }

    private boolean parentalSearch(Field field) {
        Boolean gqf = GraphQLAnnotations.isGraphQLField(field);
        if (gqf != null) {
            return gqf;
        }
        Class<?> cls = field.getDeclaringClass();
        do {
            if ((gqf = GraphQLAnnotations.isGraphQLField(cls)) == null) continue;
            return gqf;
        } while ((cls = cls.getSuperclass()) != null);
        return false;
    }

    @Override
    public GraphQLObjectType getObject(Class<?> object) throws GraphQLAnnotationsException {
        String typeName = this.getTypeName(object);
        this.processing.push(typeName);
        GraphQLObjectType.Builder builder = this.getObjectBuilder(object);
        this.processing.pop();
        return new GraphQLObjectTypeWrapper(object, builder.build());
    }

    @Override
    public GraphQLOutputType getObjectOrRef(Class<?> object) throws GraphQLAnnotationsException {
        String typeName = this.getTypeName(object);
        if (this.processing.contains(typeName)) {
            return new GraphQLTypeReference(typeName);
        }
        return this.getObject(object);
    }

    public static GraphQLObjectType object(Class<?> object) throws GraphQLAnnotationsException {
        return GraphQLAnnotations.getInstance().getObject(object);
    }

    @Override
    public GraphQLObjectType.Builder getObjectBuilder(Class<?> object) throws GraphQLAnnotationsException {
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject();
        builder.name(this.getTypeName(object));
        GraphQLDescription description = object.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        for (Method method : this.getOrderedMethods(object)) {
            if (method.isBridge() || method.isSynthetic() || !this.breadthFirstSearch(method)) continue;
            builder.field(this.getField(method));
        }
        for (Field field : this.getAllFields(object).values()) {
            if (Modifier.isStatic(field.getModifiers()) || !this.parentalSearch(field)) continue;
            builder.field(this.getField(field));
        }
        for (Iterator<AccessibleObject> iterator : object.getInterfaces()) {
            if (((Class)((Object)iterator)).getAnnotation(GraphQLTypeResolver.class) == null) continue;
            builder.withInterface((GraphQLInterfaceType)this.getInterface((Class<?>)((Object)iterator)));
        }
        return builder;
    }

    public static GraphQLObjectType.Builder objectBuilder(Class<?> object) throws GraphQLAnnotationsException {
        return GraphQLAnnotations.getInstance().getObjectBuilder(object);
    }

    protected List<Method> getOrderedMethods(Class c) {
        return Arrays.stream(c.getMethods()).sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
    }

    protected Map<String, Field> getAllFields(Class c) {
        Map<Object, Object> fields = c.getSuperclass() != null ? this.getAllFields(c.getSuperclass()) : new TreeMap();
        for (Field f : c.getDeclaredFields()) {
            fields.put(f.getName(), f);
        }
        return fields;
    }

    protected GraphQLFieldDefinition getField(Field field) throws GraphQLAnnotationsException {
        GraphQLDeprecate deprecate;
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        GraphQLName name = field.getAnnotation(GraphQLName.class);
        builder.name(NamingKit.toGraphqlName(name == null ? field.getName() : name.value()));
        GraphQLType annotation = field.getAnnotation(GraphQLType.class);
        TypeFunction typeFunction = this.defaultTypeFunction;
        if (annotation != null) {
            typeFunction = ReflectionKit.newInstance(annotation.value());
        }
        GraphQLOutputType type = (GraphQLOutputType)typeFunction.buildType(field.getType(), field.getAnnotatedType());
        GraphQLOutputType outputType = field.getAnnotation(NotNull.class) == null ? type : new GraphQLNonNull((graphql.schema.GraphQLType)type);
        boolean isConnection = this.isConnection(field, field.getType(), type);
        outputType = this.getGraphQLConnection(isConnection, field, type, outputType, builder);
        builder.type(outputType);
        GraphQLDescription description = field.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        if ((deprecate = field.getAnnotation(GraphQLDeprecate.class)) != null) {
            builder.deprecate(deprecate.value());
        }
        if (field.getAnnotation(Deprecated.class) != null) {
            builder.deprecate("Deprecated");
        }
        GraphQLDataFetcher dataFetcher = field.getAnnotation(GraphQLDataFetcher.class);
        DataFetcher actualDataFetcher = null;
        if (Objects.nonNull(dataFetcher)) {
            actualDataFetcher = this.constructDataFetcher(field.getName(), dataFetcher);
        }
        if (actualDataFetcher == null) {
            StringBuilder fluentBuffer = new StringBuilder(field.getName());
            fluentBuffer.setCharAt(0, Character.toLowerCase(fluentBuffer.charAt(0)));
            String fluentGetter = fluentBuffer.toString();
            boolean hasFluentGetter = false;
            Method fluentMethod = null;
            try {
                fluentMethod = field.getDeclaringClass().getMethod(fluentGetter, new Class[0]);
                hasFluentGetter = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (outputType == Scalars.GraphQLBoolean || outputType instanceof GraphQLNonNull && ((GraphQLNonNull)outputType).getWrappedType() == Scalars.GraphQLBoolean) {
                if (this.checkIfPrefixGetterExists(field.getDeclaringClass(), "is", field.getName()) || this.checkIfPrefixGetterExists(field.getDeclaringClass(), "get", field.getName())) {
                    actualDataFetcher = new PropertyDataFetcher(field.getName());
                }
            } else if (this.checkIfPrefixGetterExists(field.getDeclaringClass(), "get", field.getName())) {
                actualDataFetcher = new PropertyDataFetcher(field.getName());
            } else if (hasFluentGetter) {
                actualDataFetcher = new MethodDataFetcher(fluentMethod, typeFunction);
            }
            if (actualDataFetcher == null) {
                actualDataFetcher = new FieldDataFetcher(field.getName());
            }
        }
        if (isConnection) {
            actualDataFetcher = new ConnectionDataFetcher(field.getAnnotation(GraphQLConnection.class).connection(), actualDataFetcher);
        }
        builder.dataFetcher(actualDataFetcher);
        return new GraphQLFieldDefinitionWrapper(builder.build());
    }

    private DataFetcher constructDataFetcher(String fieldName, GraphQLDataFetcher annotatedDataFetcher) {
        String[] args = annotatedDataFetcher.firstArgIsTargetName() ? (String[])Stream.concat(Stream.of(fieldName), Arrays.stream(annotatedDataFetcher.args())).toArray(String[]::new) : annotatedDataFetcher.args();
        if (args.length == 0) {
            return ReflectionKit.newInstance(annotatedDataFetcher.value());
        }
        try {
            Constructor<? extends DataFetcher> ctr = annotatedDataFetcher.value().getDeclaredConstructor((Class[])Arrays.stream(args).map(v -> String.class).toArray(Class[]::new));
            return ReflectionKit.constructNewInstance(ctr, args);
        }
        catch (NoSuchMethodException e) {
            throw new GraphQLAnnotationsException("Unable to instantiate DataFetcher via constructor for: " + fieldName, e);
        }
    }

    protected GraphQLFieldDefinition field(Field field) throws IllegalAccessException, InstantiationException {
        return GraphQLAnnotations.getInstance().getField(field);
    }

    private boolean checkIfPrefixGetterExists(Class c, String prefix, String propertyName) {
        String getterName = prefix + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            Method method = c.getMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException x) {
            return false;
        }
        return true;
    }

    private GraphQLOutputType getGraphQLConnection(boolean isConnection, AccessibleObject field, GraphQLOutputType type, GraphQLOutputType outputType, GraphQLFieldDefinition.Builder builder) {
        if (isConnection && type instanceof GraphQLList) {
            graphql.schema.GraphQLType wrappedType = ((GraphQLList)type).getWrappedType();
            assert (wrappedType instanceof GraphQLObjectType);
            String annValue = field.getAnnotation(GraphQLConnection.class).name();
            String connectionName = annValue.isEmpty() ? wrappedType.getName() : annValue;
            GraphQLObjectType edgeType = RELAY_TYPES.edgeType(connectionName, (GraphQLOutputType)wrappedType, null, Collections.emptyList());
            outputType = RELAY_TYPES.connectionType(connectionName, edgeType, Collections.emptyList());
            builder.argument(RELAY_TYPES.getConnectionFieldArguments());
        }
        return outputType;
    }

    private boolean isConnection(AccessibleObject obj, Class<?> klass, GraphQLOutputType type) {
        return obj.isAnnotationPresent(GraphQLConnection.class) && type instanceof GraphQLList && ((GraphQLList)type).getWrappedType() instanceof GraphQLObjectType;
    }

    protected GraphQLFieldDefinition getField(Method method) throws GraphQLAnnotationsException {
        GraphQLDataFetcher dataFetcher;
        GraphQLDeprecate deprecate;
        GraphQLFieldDefinition.Builder builder = GraphQLFieldDefinition.newFieldDefinition();
        String name = method.getName().replaceFirst("^(is|get|set)(.+)", "$2");
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        GraphQLName nameAnn = method.getAnnotation(GraphQLName.class);
        builder.name(NamingKit.toGraphqlName(nameAnn == null ? name : nameAnn.value()));
        GraphQLType annotation = method.getAnnotation(GraphQLType.class);
        TypeFunction typeFunction = this.defaultTypeFunction;
        if (annotation != null) {
            typeFunction = ReflectionKit.newInstance(annotation.value());
        }
        AnnotatedType annotatedReturnType = method.getAnnotatedReturnType();
        TypeFunction outputTypeFunction = method.getAnnotation(GraphQLBatched.class) != null ? new BatchedTypeFunction(typeFunction) : typeFunction;
        GraphQLOutputType type = (GraphQLOutputType)outputTypeFunction.buildType(method.getReturnType(), annotatedReturnType);
        GraphQLOutputType outputType = method.getAnnotation(NotNull.class) == null ? type : new GraphQLNonNull((graphql.schema.GraphQLType)type);
        boolean isConnection = this.isConnection(method, method.getReturnType(), type);
        outputType = this.getGraphQLConnection(isConnection, method, type, outputType, builder);
        builder.type(outputType);
        TypeFunction finalTypeFunction = typeFunction;
        List<GraphQLArgument> args = Arrays.asList(method.getParameters()).stream().filter(p -> !DataFetchingEnvironment.class.isAssignableFrom(p.getType())).map(parameter -> {
            Class<?> t = parameter.getType();
            graphql.schema.GraphQLType graphQLType = finalTypeFunction.buildType(t, parameter.getAnnotatedType());
            if (graphQLType instanceof GraphQLObjectType) {
                GraphQLInputObjectType inputObject = this.getInputObject((GraphQLObjectType)graphQLType, "input");
                graphQLType = inputObject;
            }
            return this.getArgument((Parameter)parameter, graphQLType);
        }).collect(Collectors.toList());
        GraphQLFieldDefinition relay = null;
        if (method.isAnnotationPresent(GraphQLRelayMutation.class)) {
            if (!(outputType instanceof GraphQLObjectType) && !(outputType instanceof GraphQLInterfaceType)) {
                throw new RuntimeException("outputType should be an object or an interface");
            }
            StringBuilder titleBuffer = new StringBuilder(method.getName());
            titleBuffer.setCharAt(0, Character.toUpperCase(titleBuffer.charAt(0)));
            String title = titleBuffer.toString();
            List fieldDefinitions = outputType instanceof GraphQLObjectType ? ((GraphQLObjectType)outputType).getFieldDefinitions() : ((GraphQLInterfaceType)outputType).getFieldDefinitions();
            relay = RELAY_TYPES.mutationWithClientMutationId(title, method.getName(), args.stream().map(t -> GraphQLInputObjectField.newInputObjectField().name(t.getName()).type(t.getType()).description(t.getDescription()).build()).collect(Collectors.toList()), fieldDefinitions, null);
            builder.argument(relay.getArguments());
            builder.type(relay.getType());
        } else {
            builder.argument(args);
        }
        GraphQLDescription description = method.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        if ((deprecate = method.getAnnotation(GraphQLDeprecate.class)) != null) {
            builder.deprecate(deprecate.value());
        }
        if (method.getAnnotation(Deprecated.class) != null) {
            builder.deprecate("Deprecated");
        }
        Object actualDataFetcher = (dataFetcher = method.getAnnotation(GraphQLDataFetcher.class)) == null && method.getAnnotation(GraphQLBatched.class) != null ? new BatchedMethodDataFetcher(method, typeFunction) : (dataFetcher == null ? new MethodDataFetcher(method, typeFunction) : this.constructDataFetcher(method.getName(), dataFetcher));
        if (method.isAnnotationPresent(GraphQLRelayMutation.class) && relay != null) {
            actualDataFetcher = new RelayMutationMethodDataFetcher(method, args, relay.getArgument("input").getType(), relay.getType());
        }
        if (isConnection) {
            actualDataFetcher = new ConnectionDataFetcher(method.getAnnotation(GraphQLConnection.class).connection(), (DataFetcher)actualDataFetcher);
        }
        builder.dataFetcher((DataFetcher)actualDataFetcher);
        return new GraphQLFieldDefinitionWrapper(builder.build());
    }

    protected static GraphQLFieldDefinition field(Method method) throws InstantiationException, IllegalAccessException {
        return GraphQLAnnotations.getInstance().getField(method);
    }

    @Override
    public GraphQLInputObjectType getInputObject(GraphQLObjectType graphQLType, String newNamePrefix) {
        GraphQLObjectType object = graphQLType;
        return new GraphQLInputObjectType("" + newNamePrefix + object.getName(), object.getDescription(), object.getFieldDefinitions().stream().map(field -> {
            GraphQLOutputType type = field.getType();
            Object inputType = type instanceof GraphQLObjectType ? this.getInputObject((GraphQLObjectType)type, newNamePrefix) : (GraphQLInputType)type;
            return new GraphQLInputObjectField(field.getName(), field.getDescription(), inputType, null);
        }).collect(Collectors.toList()));
    }

    public static GraphQLInputObjectType inputObject(GraphQLObjectType graphQLType, String newNamePrefix) {
        return GraphQLAnnotations.getInstance().getInputObject(graphQLType, newNamePrefix);
    }

    protected GraphQLArgument getArgument(Parameter parameter, graphql.schema.GraphQLType t) throws GraphQLAnnotationsException {
        GraphQLName name;
        GraphQLDefaultValue defaultValue;
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.type((GraphQLInputType)(parameter.getAnnotation(NotNull.class) == null ? (GraphQLInputType)t : new GraphQLNonNull(t)));
        GraphQLDescription description = parameter.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        if ((defaultValue = parameter.getAnnotation(GraphQLDefaultValue.class)) != null) {
            builder.defaultValue(ReflectionKit.newInstance(defaultValue.value()).get());
        }
        if ((name = parameter.getAnnotation(GraphQLName.class)) != null) {
            builder.name(NamingKit.toGraphqlName(name.value()));
        } else {
            builder.name(NamingKit.toGraphqlName(parameter.getName()));
        }
        return builder.build();
    }

    @Reference(target="(type=default)")
    public void setDefaultTypeFunction(TypeFunction function) {
        this.defaultTypeFunction = function;
        ((DefaultTypeFunction)this.defaultTypeFunction).setAnnotationsProcessor(this);
    }

    public void registerType(TypeFunction typeFunction) {
        ((DefaultTypeFunction)this.defaultTypeFunction).register(typeFunction);
    }

    public static void register(TypeFunction typeFunction) {
        GraphQLAnnotations.getInstance().registerType(typeFunction);
    }

    public Map<String, graphql.schema.GraphQLType> getTypeRegistry() {
        return this.typeRegistry;
    }

    private class UnionTypeResolver
    implements TypeResolver {
        private final Map<Class<?>, graphql.schema.GraphQLType> types = new HashMap();

        public UnionTypeResolver(Class<?>[] classes) {
            Arrays.stream(classes).forEach(c -> this.types.put((Class<?>)c, GraphQLAnnotations.this.defaultTypeFunction.buildType((Class<?>)c, null)));
        }

        public GraphQLObjectType getType(TypeResolutionEnvironment env) {
            Object object = env.getObject();
            Optional<Map.Entry> maybeType = this.types.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(object.getClass())).findFirst();
            if (maybeType.isPresent()) {
                return (GraphQLObjectType)maybeType.get().getValue();
            }
            throw new RuntimeException("Unknown type " + object.getClass());
        }
    }

    private static class ConnectionDataFetcher
    implements DataFetcher {
        private final Class<? extends Connection> connection;
        private final DataFetcher actualDataFetcher;
        private final Constructor<Connection> constructor;

        public ConnectionDataFetcher(Class<? extends Connection> connection, DataFetcher actualDataFetcher) {
            this.connection = connection;
            Optional<Constructor> constructor = Arrays.asList(connection.getConstructors()).stream().filter(c -> c.getParameterCount() == 1).map(c -> c).findFirst();
            if (!constructor.isPresent()) {
                throw new IllegalArgumentException(connection + " doesn't have a single argument constructor");
            }
            this.constructor = constructor.get();
            this.actualDataFetcher = actualDataFetcher;
        }

        public Object get(DataFetchingEnvironment environment) {
            DataFetchingEnvironmentImpl env = new DataFetchingEnvironmentImpl(environment.getSource(), new HashMap(), environment.getContext(), environment.getFields(), environment.getFieldType(), environment.getParentType(), environment.getGraphQLSchema(), environment.getFragmentsByName(), environment.getExecutionId(), environment.getSelectionSet());
            Connection conn = ReflectionKit.constructNewInstance(this.constructor, this.actualDataFetcher.get((DataFetchingEnvironment)env));
            return conn.get(environment);
        }
    }

    public static class GraphQLFieldDefinitionWrapper
    extends GraphQLFieldDefinition {
        public GraphQLFieldDefinitionWrapper(GraphQLFieldDefinition fieldDefinition) {
            super(fieldDefinition.getName(), fieldDefinition.getDescription(), fieldDefinition.getType(), fieldDefinition.getDataFetcher(), fieldDefinition.getArguments(), fieldDefinition.getDeprecationReason());
        }

        public boolean equals(Object obj) {
            return obj instanceof GraphQLFieldDefinition && ((GraphQLFieldDefinition)obj).getName().contentEquals(this.getName());
        }
    }
}

