/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.GraphQLException;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ValuesResolver;
import graphql.execution.instrumentation.Instrumentation;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.schema.GraphQLSchema;
import java.util.LinkedHashMap;
import java.util.Map;

public class ExecutionContextBuilder {
    private ValuesResolver valuesResolver;
    private Instrumentation instrumentation;
    private ExecutionId executionId;

    public ExecutionContextBuilder(ValuesResolver valuesResolver, Instrumentation instrumentation) {
        this.valuesResolver = valuesResolver;
        this.instrumentation = instrumentation;
    }

    public ExecutionContextBuilder executionId(ExecutionId executionId) {
        this.executionId = executionId;
        return this;
    }

    public ExecutionContext build(GraphQLSchema graphQLSchema, ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Object root, Document document, String operationName, Map<String, Object> args) {
        Assert.assertNotNull((Object)this.executionId, (String)"You must provide a query identifier");
        LinkedHashMap<String, FragmentDefinition> fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
        LinkedHashMap<String, OperationDefinition> operationsByName = new LinkedHashMap<String, OperationDefinition>();
        for (Definition definition : document.getDefinitions()) {
            if (definition instanceof OperationDefinition) {
                OperationDefinition operationDefinition = (OperationDefinition)definition;
                operationsByName.put(operationDefinition.getName(), operationDefinition);
            }
            if (!(definition instanceof FragmentDefinition)) continue;
            FragmentDefinition fragmentDefinition = (FragmentDefinition)definition;
            fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
        }
        if (operationName == null && operationsByName.size() > 1) {
            throw new GraphQLException("missing operation name");
        }
        OperationDefinition operation = operationName == null ? (OperationDefinition)operationsByName.values().iterator().next() : (OperationDefinition)operationsByName.get(operationName);
        if (operation == null) {
            throw new GraphQLException();
        }
        Map<String, Object> variableValues = this.valuesResolver.getVariableValues(graphQLSchema, operation.getVariableDefinitions(), args);
        return new ExecutionContext(this.instrumentation, this.executionId, graphQLSchema, queryStrategy, mutationStrategy, subscriptionStrategy, fragmentsByName, operation, variableValues, root);
    }
}

