/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionParameters;
import graphql.execution.ExecutionStrategy;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.TypeInfo;
import graphql.language.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleExecutionStrategy
extends ExecutionStrategy {
    @Override
    public ExecutionResult execute(ExecutionContext executionContext, ExecutionParameters parameters) throws NonNullableFieldWasNullException {
        Map<String, List<Field>> fields = parameters.fields();
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String fieldName : fields.keySet()) {
            List<Field> fieldList = fields.get(fieldName);
            try {
                ExecutionResult resolvedResult = this.resolveField(executionContext, parameters, fieldList);
                results.put(fieldName, resolvedResult != null ? resolvedResult.getData() : null);
            }
            catch (NonNullableFieldWasNullException e) {
                TypeInfo typeInfo = e.getTypeInfo();
                if (typeInfo.hasParentType() && typeInfo.parentTypeInfo().typeIsNonNull()) {
                    throw e;
                }
                results = null;
                break;
            }
        }
        return new ExecutionResultImpl(results, executionContext.getErrors());
    }
}

