/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLException;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SimpleExecutionStrategy;
import graphql.language.Field;
import graphql.schema.GraphQLObjectType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ExecutorServiceExecutionStrategy
extends ExecutionStrategy {
    ExecutorService executorService;

    public ExecutorServiceExecutionStrategy(ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Override
    public ExecutionResult execute(final ExecutionContext executionContext, final GraphQLObjectType parentType, final Object source, Map<String, List<Field>> fields) {
        if (this.executorService == null) {
            return new SimpleExecutionStrategy().execute(executionContext, parentType, source, fields);
        }
        LinkedHashMap<String, Future<ExecutionResult>> futures = new LinkedHashMap<String, Future<ExecutionResult>>();
        for (String fieldName : fields.keySet()) {
            final List<Field> fieldList = fields.get(fieldName);
            Callable<ExecutionResult> resolveField = new Callable<ExecutionResult>(){

                @Override
                public ExecutionResult call() throws Exception {
                    return ExecutorServiceExecutionStrategy.this.resolveField(executionContext, parentType, source, fieldList);
                }
            };
            futures.put(fieldName, this.executorService.submit(resolveField));
        }
        try {
            LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
            Iterator i$ = futures.keySet().iterator();
            while (i$.hasNext()) {
                String fieldName;
                ExecutionResult executionResult = (ExecutionResult)((Future)futures.get(fieldName = (String)i$.next())).get();
                results.put(fieldName, executionResult != null ? executionResult.getData() : null);
            }
            return new ExecutionResultImpl(results, executionContext.getErrors());
        }
        catch (InterruptedException e) {
            throw new GraphQLException(e);
        }
        catch (ExecutionException e) {
            throw new GraphQLException(e);
        }
    }
}

