/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.batched;

import graphql.execution.batched.GraphQLExecutionNodeDatum;
import graphql.schema.GraphQLObjectType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChildDataCollector {
    private final Map<String, List<GraphQLExecutionNodeDatum>> childDataByTypename = new HashMap<String, List<GraphQLExecutionNodeDatum>>();
    private final Map<String, GraphQLObjectType> childTypesByName = new HashMap<String, GraphQLObjectType>();

    public void putChildData(GraphQLObjectType objectType, GraphQLExecutionNodeDatum datum) {
        this.childTypesByName.put(objectType.getName(), objectType);
        this.multimapPut(this.childDataByTypename, objectType.getName(), datum);
    }

    private <K, V> void multimapPut(Map<K, List<V>> map, K key, V value) {
        this.multimapEnsureKey(map, key);
        map.get(key).add(value);
    }

    private <K, V> void multimapEnsureKey(Map<K, List<V>> map, K key) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
    }

    private <K, V> List<V> multimapGet(Map<K, List<V>> map, K key) {
        this.multimapEnsureKey(map, key);
        return map.get(key);
    }

    public List<Entry> getEntries() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (String childTypename : this.childTypesByName.keySet()) {
            GraphQLObjectType childType = this.childTypesByName.get(childTypename);
            List<GraphQLExecutionNodeDatum> childData = this.multimapGet(this.childDataByTypename, childTypename);
            entries.add(new Entry(childType, childData));
        }
        return entries;
    }

    public static class Entry {
        private final GraphQLObjectType objectType;
        private final List<GraphQLExecutionNodeDatum> data;

        public Entry(GraphQLObjectType objectType, List<GraphQLExecutionNodeDatum> data) {
            this.objectType = objectType;
            this.data = data;
        }

        public GraphQLObjectType getObjectType() {
            return this.objectType;
        }

        public List<GraphQLExecutionNodeDatum> getData() {
            return this.data;
        }
    }
}

