/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.servlet.DefaultGraphQLContextBuilder;
import graphql.servlet.EnhancedExecutionStrategyProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLMutationProvider;
import graphql.servlet.GraphQLOperationListener;
import graphql.servlet.GraphQLQueryProvider;
import graphql.servlet.GraphQLServlet;
import graphql.servlet.GraphQLTypesProvider;
import graphql.servlet.GraphQLVariables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={HttpServlet.class}, property={"alias=/graphql", "jmx.objectname=graphql.servlet:type=graphql"})
public class OsgiGraphQLServlet
extends GraphQLServlet {
    private static final Logger log = LoggerFactory.getLogger(OsgiGraphQLServlet.class);
    private List<GraphQLQueryProvider> queryProviders = new ArrayList<GraphQLQueryProvider>();
    private List<GraphQLMutationProvider> mutationProviders = new ArrayList<GraphQLMutationProvider>();
    private List<GraphQLTypesProvider> typesProviders = new ArrayList<GraphQLTypesProvider>();
    private GraphQLSchema schema;
    private GraphQLSchema readOnlySchema;
    private GraphQLContextBuilder contextBuilder = new DefaultGraphQLContextBuilder();
    private ExecutionStrategyProvider executionStrategyProvider = new EnhancedExecutionStrategyProvider();

    protected void updateSchema() {
        GraphQLObjectType.Builder object = GraphQLObjectType.newObject().name("query");
        for (GraphQLQueryProvider graphQLQueryProvider : this.queryProviders) {
            GraphQLObjectType graphQLObjectType = graphQLQueryProvider.getQuery();
            object.field(GraphQLFieldDefinition.newFieldDefinition().type((GraphQLOutputType)graphQLObjectType).staticValue(graphQLQueryProvider.context()).name(graphQLQueryProvider.getName()).description(graphQLObjectType.getDescription()).build());
        }
        HashSet<GraphQLType> types = new HashSet<GraphQLType>();
        for (GraphQLTypesProvider graphQLTypesProvider : this.typesProviders) {
            types.addAll(graphQLTypesProvider.getTypes());
        }
        this.readOnlySchema = GraphQLSchema.newSchema().query(object.build()).build(types);
        if (this.mutationProviders.isEmpty()) {
            this.schema = this.readOnlySchema;
        } else {
            GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name("mutation");
            for (GraphQLMutationProvider provider : this.mutationProviders) {
                provider.getMutations().forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0));
            }
            GraphQLObjectType graphQLObjectType = builder.build();
            this.schema = graphQLObjectType.getFieldDefinitions().size() == 0 ? this.readOnlySchema : GraphQLSchema.newSchema().query(object.build()).mutation(graphQLObjectType).build();
        }
    }

    public OsgiGraphQLServlet() {
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.add(queryProvider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.remove(queryProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.add(mutationProvider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.remove(mutationProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void typesProviders(GraphQLTypesProvider typesProvider) {
        this.typesProviders.add(typesProvider);
        this.updateSchema();
    }

    public void unbindTypesProvider(GraphQLTypesProvider typesProvider) {
        this.typesProviders.remove(typesProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    public void setContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    public void unsetContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = new DefaultGraphQLContextBuilder();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public void setExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = provider;
    }

    public void unsetExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = new EnhancedExecutionStrategyProvider();
    }

    @Override
    protected GraphQLContext createContext(Optional<HttpServletRequest> req, Optional<HttpServletResponse> resp) {
        return this.contextBuilder.build(req, resp);
    }

    @Override
    protected ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategyProvider.getExecutionStrategy();
    }

    @Override
    protected Map<String, Object> transformVariables(GraphQLSchema schema, String query, Map<String, Object> variables) {
        return new GraphQLVariables(schema, query, variables);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    public void bindOperationListener(GraphQLOperationListener listener) {
        this.addOperationListener(listener);
    }

    public void unbindOperationListener(GraphQLOperationListener listener) {
        this.removeOperationListener(listener);
    }

    @Override
    public GraphQLSchema getSchema() {
        return this.schema;
    }

    @Override
    public GraphQLSchema getReadOnlySchema() {
        return this.readOnlySchema;
    }
}

