/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLOperationListener;
import graphql.servlet.GraphQLServlet;
import graphql.servlet.GraphQLServletListener;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SimpleGraphQLServlet
extends GraphQLServlet {
    public static final GraphQLObjectType EMPTY_MUTATION_TYPE = GraphQLObjectType.newObject().name("Mutation").build();
    private final GraphQLSchema schema;
    private final GraphQLSchema readOnlySchema;
    private final ExecutionStrategy executionStrategy;

    public SimpleGraphQLServlet(GraphQLSchema schema, ExecutionStrategy executionStrategy) {
        this(schema, executionStrategy, null, null);
    }

    public SimpleGraphQLServlet(GraphQLSchema schema, ExecutionStrategy executionStrategy, List<GraphQLOperationListener> operationListeners, List<GraphQLServletListener> servletListeners) {
        super(operationListeners, servletListeners, null);
        this.schema = schema;
        this.readOnlySchema = new GraphQLSchema(schema.getQueryType(), EMPTY_MUTATION_TYPE, schema.getDictionary());
        this.executionStrategy = executionStrategy;
    }

    @Override
    public GraphQLSchema getSchema() {
        return this.schema;
    }

    @Override
    public GraphQLSchema getReadOnlySchema() {
        return this.readOnlySchema;
    }

    @Override
    protected GraphQLContext createContext(Optional<HttpServletRequest> request, Optional<HttpServletResponse> response) {
        return new GraphQLContext(request, response);
    }

    @Override
    protected ExecutionStrategy getExecutionStrategy() {
        return this.executionStrategy;
    }

    @Override
    protected Map<String, Object> transformVariables(GraphQLSchema schema, String query, Map<String, Object> variables) {
        return variables;
    }
}

