/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2019 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
package com.javaoffers.thrid.jsqlparser.expression;

import com.javaoffers.thrid.jsqlparser.parser.ASTNodeAccessImpl;

public class CollateExpression extends ASTNodeAccessImpl implements Expression {

    private Expression leftExpression;
    private String collate;

    public CollateExpression() {
        // empty constructor
    }

    public CollateExpression(Expression leftExpression, String collate) {
        this.leftExpression = leftExpression;
        this.collate = collate;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public Expression getLeftExpression() {
        return leftExpression;
    }

    public void setLeftExpression(Expression leftExpression) {
        this.leftExpression = leftExpression;
    }

    public String getCollate() {
        return collate;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    @Override
    public String toString() {
        return leftExpression.toString() + " COLLATE " + collate;
    }

    public CollateExpression withLeftExpression(Expression leftExpression) {
        this.setLeftExpression(leftExpression);
        return this;
    }

    public CollateExpression withCollate(String collate) {
        this.setCollate(collate);
        return this;
    }

    public <E extends Expression> E getLeftExpression(Class<E> type) {
        return type.cast(getLeftExpression());
    }
}
