/*-
 * #%L
 * JSQLParser library
 * %%
 * Copyright (C) 2004 - 2020 JSQLParser
 * %%
 * Dual licensed under GNU LGPL 2.1 or Apache License 2.0
 * #L%
 */
package com.javaoffers.thrid.jsqlparser.util.validation.metadata;

import com.javaoffers.thrid.jsqlparser.util.validation.ValidationException;

import java.sql.SQLException;

/**
 * database-errors wrapping a {@link SQLException} or PersistenceException
 * @author gitmotte
 */
public class DatabaseException extends ValidationException {

    private static final long serialVersionUID = 1L;

    public DatabaseException(String message, Throwable cause) {
        super(message, cause);
    }

    public DatabaseException(String message) {
        super(message);
    }

    public DatabaseException(Throwable cause) {
        super(cause);
    }

}
