/*
 * Decompiled with CFR 0.152.
 */
package com.kttdevelopment.simplehttpserver;

import java.text.SimpleDateFormat;
import java.util.Date;

public class SimpleHttpCookie {
    private final String name;
    private final String value;
    private final String domain;
    private final String path;
    private final String sameSite;
    private final Date expires;
    private final Integer maxAge;
    private final Boolean secure;
    private final Boolean httpOnly;
    private final SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss");

    private SimpleHttpCookie(String name, String value, String domain, String path, String sameSite, Date expires, Integer maxAge, Boolean secure, Boolean httpOnly) {
        if (name == null) {
            throw new NullPointerException("Cookie name can not be null");
        }
        this.name = name;
        if (value == null) {
            throw new NullPointerException("Cookie value can not be null");
        }
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.sameSite = sameSite;
        this.expires = expires;
        this.maxAge = maxAge;
        this.secure = secure;
        this.httpOnly = httpOnly;
    }

    public final String toCookieHeaderString() {
        StringBuilder OUT = new StringBuilder();
        OUT.append(this.name).append("=").append(this.value);
        if (this.expires != null) {
            OUT.append("; Expires=").append(this.sdf.format(this.expires)).append(" GMT");
        }
        if (this.maxAge != null) {
            OUT.append("; Max-Age=").append(this.maxAge);
        }
        if (this.domain != null) {
            OUT.append("; Domain=").append(this.domain);
        }
        if (this.path != null) {
            OUT.append("; Path=").append(this.path);
        }
        if (this.secure != null && this.secure.booleanValue()) {
            OUT.append("; Secure=").append(true);
        }
        if (this.httpOnly != null && this.httpOnly.booleanValue()) {
            OUT.append("; HttpOnly=").append(true);
        }
        if (this.sameSite != null) {
            OUT.append("; SameSite=").append(this.sameSite);
        }
        return OUT.toString();
    }

    public String toString() {
        return "SimpleHttpCookie{name='" + this.name + "', value='" + this.value + "', expires=" + this.expires + ", maxAge=" + this.maxAge + ", domain='" + this.domain + "', path='" + this.path + "', secure=" + this.secure + ", httpOnly=" + this.httpOnly + ", sameSite='" + this.sameSite + "'}";
    }

    public static class Builder {
        private final String name;
        private final String value;
        private String domain;
        private String path;
        private String sameSite;
        private Date expires;
        private Integer maxAge;
        private Boolean secure;
        private Boolean httpOnly;

        public Builder(String name, String value) {
            this.name = name;
            if (this.name == null) {
                throw new NullPointerException("Cookie name can not be null");
            }
            this.value = value;
            if (this.value == null) {
                throw new NullPointerException("Cookie value can not be null");
            }
        }

        public final String getName() {
            return this.name;
        }

        public final String getValue() {
            return this.value;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final Builder setDomain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public final String isSameSite() {
            return this.sameSite;
        }

        public final Builder setSameSite(String sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public final Date getExpires() {
            return this.expires;
        }

        public final Builder setExpires(Date expires) {
            this.expires = expires;
            return this;
        }

        public final int getMaxAge() {
            return this.maxAge;
        }

        public final Builder setMaxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public final boolean isSecure() {
            return this.secure;
        }

        public final Builder setSecure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public final boolean isHttpOnly() {
            return this.httpOnly;
        }

        public final Builder setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        public final SimpleHttpCookie build() {
            return new SimpleHttpCookie(this.name, this.value, this.domain, this.path, this.sameSite, this.expires, this.maxAge, this.secure, this.httpOnly);
        }
    }
}

