/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDUser;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.UserAttribute;
import com.launchdarkly.sdk.server.DataModel;
import org.apache.commons.codec.digest.DigestUtils;

abstract class EvaluatorBucketing {
    private static final float LONG_SCALE = 1.1529215E18f;

    private EvaluatorBucketing() {
    }

    static Integer variationIndexForUser(DataModel.VariationOrRollout vr, LDUser user, String key, String salt) {
        Integer variation = vr.getVariation();
        if (variation != null) {
            return variation;
        }
        DataModel.Rollout rollout = vr.getRollout();
        if (rollout != null && !rollout.getVariations().isEmpty()) {
            float bucket = EvaluatorBucketing.bucketUser(user, key, rollout.getBucketBy(), salt);
            float sum = 0.0f;
            for (DataModel.WeightedVariation wv : rollout.getVariations()) {
                if (!(bucket < (sum += (float)wv.getWeight() / 100000.0f))) continue;
                return wv.getVariation();
            }
            return rollout.getVariations().get(rollout.getVariations().size() - 1).getVariation();
        }
        return null;
    }

    static float bucketUser(LDUser user, String key, UserAttribute attr, String salt) {
        LDValue userValue = user.getAttribute(attr == null ? UserAttribute.KEY : attr);
        String idHash = EvaluatorBucketing.getBucketableStringValue(userValue);
        if (idHash != null) {
            if (user.getSecondary() != null) {
                idHash = idHash + "." + user.getSecondary();
            }
            String hash = DigestUtils.sha1Hex((String)(key + "." + salt + "." + idHash)).substring(0, 15);
            long longVal = Long.parseLong(hash, 16);
            return (float)longVal / 1.1529215E18f;
        }
        return 0.0f;
    }

    private static String getBucketableStringValue(LDValue userValue) {
        switch (userValue.getType()) {
            case STRING: {
                return userValue.stringValue();
            }
            case NUMBER: {
                return userValue.isInt() ? String.valueOf(userValue.intValue()) : null;
            }
        }
        return null;
    }
}

