/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.HttpErrorException;
import com.launchdarkly.sdk.server.interfaces.DataStoreTypes;
import java.io.Closeable;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

interface FeatureRequestor
extends Closeable {
    public AllData getAllData(boolean var1) throws IOException, HttpErrorException;

    public static class AllData {
        final Map<String, DataModel.FeatureFlag> flags;
        final Map<String, DataModel.Segment> segments;

        AllData(Map<String, DataModel.FeatureFlag> flags, Map<String, DataModel.Segment> segments) {
            this.flags = flags;
            this.segments = segments;
        }

        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> toFullDataSet() {
            return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>((Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>>)ImmutableMap.of((Object)DataModel.FEATURES, AllData.toKeyedItems(DataModel.FEATURES, this.flags), (Object)DataModel.SEGMENTS, AllData.toKeyedItems(DataModel.SEGMENTS, this.segments)).entrySet());
        }

        static DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> toKeyedItems(DataStoreTypes.DataKind kind, Map<String, ? extends DataModel.VersionedData> itemsMap) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (itemsMap != null) {
                for (Map.Entry<String, ? extends DataModel.VersionedData> e : itemsMap.entrySet()) {
                    DataStoreTypes.ItemDescriptor item = new DataStoreTypes.ItemDescriptor(e.getValue().getVersion(), e.getValue());
                    builder.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(e.getKey(), item));
                }
            }
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>((Iterable<Map.Entry<String, DataStoreTypes.ItemDescriptor>>)builder.build());
        }
    }
}

