/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.Function;
import com.launchdarkly.shaded.com.google.gson.JsonParseException;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.util.Iterator;

abstract class Helpers {
    private Helpers() {
    }

    static <T, U> Iterable<U> transform(final Iterable<T> source2, final Function<T, U> fn) {
        return new Iterable<U>(){

            @Override
            public Iterator<U> iterator() {
                final Iterator sourceIterator = source2.iterator();
                return new Iterator<U>(){

                    @Override
                    public boolean hasNext() {
                        return sourceIterator.hasNext();
                    }

                    @Override
                    public U next() {
                        return fn.apply(sourceIterator.next());
                    }
                };
            }
        };
    }

    static String readNullableString(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case STRING: {
                return reader.nextString();
            }
            case NULL: {
                reader.nextNull();
                return null;
            }
        }
        throw new JsonParseException("expected string value or null");
    }

    static String readNonNullableString(JsonReader reader) throws IOException {
        switch (reader.peek()) {
            case STRING: {
                return reader.nextString();
            }
        }
        throw new JsonParseException("expected string value");
    }
}

