/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.ArrayBuilder;
import com.launchdarkly.sdk.Function;
import com.launchdarkly.sdk.Helpers;
import com.launchdarkly.sdk.LDValueBool;
import com.launchdarkly.sdk.LDValueNull;
import com.launchdarkly.sdk.LDValueNumber;
import com.launchdarkly.sdk.LDValueString;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.LDValueTypeAdapter;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.google.gson.Gson;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

@JsonAdapter(value=LDValueTypeAdapter.class)
public abstract class LDValue
implements JsonSerializable {
    static final Gson gson = new Gson();

    public static LDValue normalize(LDValue value) {
        return value == null ? LDValue.ofNull() : value;
    }

    public static LDValue ofNull() {
        return LDValueNull.INSTANCE;
    }

    public static LDValue of(boolean value) {
        return LDValueBool.fromBoolean(value);
    }

    public static LDValue of(int value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(long value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(float value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(double value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(String value) {
        return value == null ? LDValue.ofNull() : LDValueString.fromString(value);
    }

    public static ArrayBuilder buildArray() {
        return new ArrayBuilder();
    }

    public static ObjectBuilder buildObject() {
        return new ObjectBuilder();
    }

    public static LDValue parse(String json) {
        try {
            return JsonSerialization.deserialize(json, LDValue.class);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract LDValueType getType();

    public boolean isNull() {
        return false;
    }

    public boolean booleanValue() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public int intValue() {
        return 0;
    }

    public long longValue() {
        return 0L;
    }

    public float floatValue() {
        return 0.0f;
    }

    public double doubleValue() {
        return 0.0;
    }

    public boolean isString() {
        return false;
    }

    public String stringValue() {
        return null;
    }

    public int size() {
        return 0;
    }

    public Iterable<String> keys() {
        return Collections.emptyList();
    }

    public Iterable<LDValue> values() {
        return Collections.emptyList();
    }

    public <T> Iterable<T> valuesAs(final Converter<T> converter) {
        return Helpers.transform(this.values(), new Function<LDValue, T>(){

            @Override
            public T apply(LDValue a) {
                return converter.toType(a);
            }
        });
    }

    public LDValue get(int index) {
        return LDValue.ofNull();
    }

    public LDValue get(String name) {
        return LDValue.ofNull();
    }

    public String toJsonString() {
        return gson.toJson(this);
    }

    abstract void write(JsonWriter var1) throws IOException;

    static boolean isInteger(double value) {
        return value == (double)((int)value);
    }

    public String toString() {
        return this.toJsonString();
    }

    public boolean equals(Object o) {
        if (o instanceof LDValue) {
            if (o == this) {
                return true;
            }
            LDValue other = (LDValue)o;
            if (this.getType() == other.getType()) {
                switch (this.getType()) {
                    case NULL: {
                        return other.isNull();
                    }
                    case NUMBER: {
                        return this.doubleValue() == other.doubleValue();
                    }
                    case BOOLEAN: {
                        return false;
                    }
                    case STRING: {
                        return this.stringValue().equals(other.stringValue());
                    }
                    case ARRAY: {
                        if (this.size() != other.size()) {
                            return false;
                        }
                        for (int i = 0; i < this.size(); ++i) {
                            if (this.get(i).equals(other.get(i))) continue;
                            return false;
                        }
                        return true;
                    }
                    case OBJECT: {
                        if (this.size() != other.size()) {
                            return false;
                        }
                        for (String name : this.keys()) {
                            if (this.get(name).equals(other.get(name))) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int hashCode() {
        switch (this.getType()) {
            case BOOLEAN: {
                return this.booleanValue() ? 1 : 0;
            }
            case NUMBER: {
                return this.intValue();
            }
            case STRING: {
                return this.stringValue().hashCode();
            }
            case ARRAY: {
                int ah = 0;
                for (LDValue v : this.values()) {
                    ah = ah * 31 + v.hashCode();
                }
                return ah;
            }
            case OBJECT: {
                int oh = 0;
                for (String name : this.keys()) {
                    oh = (oh * 31 + name.hashCode()) * 31 + this.get(name).hashCode();
                }
                return oh;
            }
        }
        return 0;
    }

    public static abstract class Convert {
        public static final Converter<Boolean> Boolean = new Converter<Boolean>(){

            @Override
            public LDValue fromType(Boolean value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Boolean toType(LDValue value) {
                return value.booleanValue();
            }
        };
        public static final Converter<Integer> Integer = new Converter<Integer>(){

            @Override
            public LDValue fromType(Integer value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Integer toType(LDValue value) {
                return value.intValue();
            }
        };
        public static final Converter<Long> Long = new Converter<Long>(){

            @Override
            public LDValue fromType(Long value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Long toType(LDValue value) {
                return value.longValue();
            }
        };
        public static final Converter<Float> Float = new Converter<Float>(){

            @Override
            public LDValue fromType(Float value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value.floatValue());
            }

            @Override
            public Float toType(LDValue value) {
                return java.lang.Float.valueOf(value.floatValue());
            }
        };
        public static final Converter<Double> Double = new Converter<Double>(){

            @Override
            public LDValue fromType(Double value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Double toType(LDValue value) {
                return value.doubleValue();
            }
        };
        public static final Converter<String> String = new Converter<String>(){

            @Override
            public LDValue fromType(String value) {
                return LDValue.of(value);
            }

            @Override
            public String toType(LDValue value) {
                return value.stringValue();
            }
        };

        private Convert() {
        }
    }

    public static abstract class Converter<T> {
        public abstract LDValue fromType(T var1);

        public abstract T toType(LDValue var1);

        public LDValue arrayFrom(Iterable<T> values2) {
            ArrayBuilder ab = LDValue.buildArray();
            for (T value : values2) {
                ab.add(this.fromType(value));
            }
            return ab.build();
        }

        public LDValue arrayOf(T ... values2) {
            ArrayBuilder ab = LDValue.buildArray();
            for (T value : values2) {
                ab.add(this.fromType(value));
            }
            return ab.build();
        }

        public LDValue objectFrom(Map<String, T> map) {
            ObjectBuilder ob = LDValue.buildObject();
            for (String key : map.keySet()) {
                ob.put(key, this.fromType(map.get(key)));
            }
            return ob.build();
        }
    }
}

