/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.sdk.json.JsonSerialization;
import com.launchdarkly.sdk.json.SerializationException;
import java.io.IOException;
import java.util.Iterator;

public class LDJackson {
    private LDJackson() {
    }

    public static Module module() {
        SimpleModule module = new SimpleModule(LDJackson.class.getName());
        module.addSerializer(JsonSerializable.class, (JsonSerializer)LDJacksonSerializer.INSTANCE);
        Iterator<Class<? extends JsonSerializable>> iterator2 = JsonSerialization.getDeserializableClasses().iterator();
        while (iterator2.hasNext()) {
            Class<? extends JsonSerializable> c;
            Class<? extends JsonSerializable> cjs = c = iterator2.next();
            module.addDeserializer(cjs, new LDJacksonDeserializer<JsonSerializable>(cjs));
        }
        return module;
    }

    private static class LDJacksonDeserializer<T extends JsonSerializable>
    extends JsonDeserializer<T> {
        private final Class<T> objectClass;

        LDJacksonDeserializer(Class<T> objectClass) {
            this.objectClass = objectClass;
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonLocation loc = p.getCurrentLocation();
            TreeNode jsonTree = p.readValueAsTree();
            String jsonString = jsonTree.toString();
            try {
                return JsonSerialization.deserialize(jsonString, this.objectClass);
            }
            catch (SerializationException e) {
                throw new JsonParseException(p, "invalid JSON encoding for " + this.objectClass.getSimpleName(), loc, (Throwable)e);
            }
        }
    }

    private static class LDJacksonSerializer
    extends JsonSerializer<JsonSerializable> {
        static final LDJacksonSerializer INSTANCE = new LDJacksonSerializer();

        private LDJacksonSerializer() {
        }

        public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String json = JsonSerialization.serializeInternal(value);
            gen.writeRawValue(json);
        }
    }
}

