/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorHelpers;
import com.launchdarkly.sdk.server.EvaluatorTypeConversion;
import com.launchdarkly.sdk.server.SemanticVersion;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;

abstract class DataModelPreprocessing {
    private DataModelPreprocessing() {
    }

    static void preprocessFlag(DataModel.FeatureFlag f) {
        f.preprocessed = new FlagPreprocessed(EvaluatorHelpers.offResult(f), DataModelPreprocessing.precomputeMultiVariationResults(f, EvaluationReason.fallthrough(false), EvaluationReason.fallthrough(true), f.isTrackEventsFallthrough()));
        for (DataModel.Prerequisite p : f.getPrerequisites()) {
            DataModelPreprocessing.preprocessPrerequisite(p, f);
        }
        for (DataModel.Target t : f.getTargets()) {
            DataModelPreprocessing.preprocessTarget(t, f);
        }
        for (DataModel.Target t : f.getContextTargets()) {
            DataModelPreprocessing.preprocessTarget(t, f);
        }
        List<DataModel.Rule> rules = f.getRules();
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            DataModelPreprocessing.preprocessFlagRule(rules.get(i), i, f);
        }
        DataModelPreprocessing.preprocessValueList(f.getVariations());
    }

    static void preprocessSegment(DataModel.Segment s) {
        List<DataModel.SegmentRule> rules = s.getRules();
        int n = rules.size();
        for (int i = 0; i < n; ++i) {
            DataModelPreprocessing.preprocessSegmentRule(rules.get(i), i);
        }
    }

    static void preprocessPrerequisite(DataModel.Prerequisite p, DataModel.FeatureFlag f) {
        p.preprocessed = new PrerequisitePreprocessed(EvaluatorHelpers.prerequisiteFailedResult(f, p));
    }

    static void preprocessTarget(DataModel.Target t, DataModel.FeatureFlag f) {
        t.preprocessed = new TargetPreprocessed(EvaluatorHelpers.targetMatchResult(f, t));
    }

    static void preprocessFlagRule(DataModel.Rule r, int ruleIndex, DataModel.FeatureFlag f) {
        EvaluationReason ruleMatchReason = EvaluationReason.ruleMatch(ruleIndex, r.getId(), false);
        EvaluationReason ruleMatchReasonInExperiment = EvaluationReason.ruleMatch(ruleIndex, r.getId(), true);
        r.preprocessed = new FlagRulePreprocessed(DataModelPreprocessing.precomputeMultiVariationResults(f, ruleMatchReason, ruleMatchReasonInExperiment, r.isTrackEvents()));
        for (DataModel.Clause c : r.getClauses()) {
            DataModelPreprocessing.preprocessClause(c);
        }
    }

    static void preprocessSegmentRule(DataModel.SegmentRule r, int ruleIndex) {
        for (DataModel.Clause c : r.getClauses()) {
            DataModelPreprocessing.preprocessClause(c);
        }
    }

    static void preprocessClause(DataModel.Clause c) {
        List<LDValue> values = c.getValues();
        DataModelPreprocessing.preprocessValueList(values);
        DataModel.Operator op = c.getOp();
        if (op == null) {
            return;
        }
        if (op == DataModel.Operator.in) {
            if (values.size() > 1) {
                c.preprocessed = new ClausePreprocessed((Set<LDValue>)ImmutableSet.copyOf(values), null);
            }
        } else if (op == DataModel.Operator.matches) {
            c.preprocessed = DataModelPreprocessing.preprocessClauseValues(c.getValues(), v -> new ClausePreprocessed.ValueData(null, EvaluatorTypeConversion.valueToRegex(v), null));
        } else if (op == DataModel.Operator.after || op == DataModel.Operator.before) {
            c.preprocessed = DataModelPreprocessing.preprocessClauseValues(c.getValues(), v -> new ClausePreprocessed.ValueData(EvaluatorTypeConversion.valueToDateTime(v), null, null));
        } else if (op == DataModel.Operator.semVerEqual || op == DataModel.Operator.semVerGreaterThan || op == DataModel.Operator.semVerLessThan) {
            c.preprocessed = DataModelPreprocessing.preprocessClauseValues(c.getValues(), v -> new ClausePreprocessed.ValueData(null, null, EvaluatorTypeConversion.valueToSemVer(v)));
        }
    }

    static void preprocessValueList(List<LDValue> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) != null) continue;
            values.set(i, LDValue.ofNull());
        }
    }

    private static ClausePreprocessed preprocessClauseValues(List<LDValue> values, Function<LDValue, ClausePreprocessed.ValueData> f) {
        ArrayList<ClausePreprocessed.ValueData> valuesExtra = new ArrayList<ClausePreprocessed.ValueData>(values.size());
        for (LDValue v : values) {
            valuesExtra.add(f.apply(v));
        }
        return new ClausePreprocessed(null, valuesExtra);
    }

    private static EvalResultFactoryMultiVariations precomputeMultiVariationResults(DataModel.FeatureFlag f, EvaluationReason regularReason, EvaluationReason inExperimentReason, boolean alwaysInExperiment) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)f.getVariations().size());
        for (int i = 0; i < f.getVariations().size(); ++i) {
            builder.add((Object)new EvalResultsForSingleVariation(f.getVariations().get(i), i, regularReason, inExperimentReason, alwaysInExperiment));
        }
        return new EvalResultFactoryMultiVariations((ImmutableList<EvalResultsForSingleVariation>)builder.build());
    }

    static final class ClausePreprocessed {
        final Set<LDValue> valuesSet;
        final List<ValueData> valuesExtra;

        ClausePreprocessed(Set<LDValue> valuesSet, List<ValueData> valuesExtra) {
            this.valuesSet = valuesSet;
            this.valuesExtra = valuesExtra;
        }

        static final class ValueData {
            final Instant parsedDate;
            final Pattern parsedRegex;
            final SemanticVersion parsedSemVer;

            ValueData(Instant parsedDate, Pattern parsedRegex, SemanticVersion parsedSemVer) {
                this.parsedDate = parsedDate;
                this.parsedRegex = parsedRegex;
                this.parsedSemVer = parsedSemVer;
            }
        }
    }

    static final class FlagRulePreprocessed {
        final EvalResultFactoryMultiVariations allPossibleResults;

        FlagRulePreprocessed(EvalResultFactoryMultiVariations allPossibleResults) {
            this.allPossibleResults = allPossibleResults;
        }
    }

    static final class TargetPreprocessed {
        final EvalResult targetMatchResult;

        TargetPreprocessed(EvalResult targetMatchResult) {
            this.targetMatchResult = targetMatchResult;
        }
    }

    static final class PrerequisitePreprocessed {
        final EvalResult prerequisiteFailedResult;

        PrerequisitePreprocessed(EvalResult prerequisiteFailedResult) {
            this.prerequisiteFailedResult = prerequisiteFailedResult;
        }
    }

    static final class FlagPreprocessed {
        EvalResult offResult;
        EvalResultFactoryMultiVariations fallthroughResults;

        FlagPreprocessed(EvalResult offResult, EvalResultFactoryMultiVariations fallthroughResults) {
            this.offResult = offResult;
            this.fallthroughResults = fallthroughResults;
        }
    }

    static final class EvalResultFactoryMultiVariations {
        private final ImmutableList<EvalResultsForSingleVariation> variations;

        EvalResultFactoryMultiVariations(ImmutableList<EvalResultsForSingleVariation> variations) {
            this.variations = variations;
        }

        EvalResult forVariation(int index, boolean inExperiment) {
            if (index < 0 || index >= this.variations.size()) {
                return EvalResult.error(EvaluationReason.ErrorKind.MALFORMED_FLAG);
            }
            return ((EvalResultsForSingleVariation)this.variations.get(index)).getResult(inExperiment);
        }
    }

    static final class EvalResultsForSingleVariation {
        private final EvalResult regularResult;
        private final EvalResult inExperimentResult;

        EvalResultsForSingleVariation(LDValue value, int variationIndex, EvaluationReason regularReason, EvaluationReason inExperimentReason, boolean alwaysInExperiment) {
            this.regularResult = EvalResult.of(value, variationIndex, regularReason).withForceReasonTracking(alwaysInExperiment);
            this.inExperimentResult = EvalResult.of(value, variationIndex, inExperimentReason).withForceReasonTracking(true);
        }

        EvalResult getResult(boolean inExperiment) {
            return inExperiment ? this.inExperimentResult : this.regularResult;
        }
    }
}

