/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelDependencies;
import com.launchdarkly.sdk.server.DataModelSerialization;
import com.launchdarkly.sdk.server.JsonHelpers;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.SerializationException;
import java.io.IOException;

abstract class StreamProcessorEvents {
    StreamProcessorEvents() {
    }

    static PutData parsePutData(JsonReader jr) {
        String path = null;
        DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data = null;
        try {
            jr.beginObject();
            block11: while (jr.peek() != JsonToken.END_OBJECT) {
                String prop;
                switch (prop = jr.nextName()) {
                    case "path": {
                        path = jr.nextString();
                        continue block11;
                    }
                    case "data": {
                        data = DataModelSerialization.parseFullDataSet(jr);
                        continue block11;
                    }
                }
                jr.skipValue();
            }
            jr.endObject();
            if (data == null) {
                throw StreamProcessorEvents.missingRequiredProperty("put", "data");
            }
            return new PutData(path, data);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        catch (RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    static PatchData parsePatchData(JsonReader jr) {
        DataStoreTypes.DataKind kind = null;
        String key = null;
        DataModel.VersionedData dataItem = null;
        JsonElement bufferedParsedData = null;
        try {
            jr.beginObject();
            block11: while (jr.peek() != JsonToken.END_OBJECT) {
                String prop;
                switch (prop = jr.nextName()) {
                    case "path": {
                        DataModelDependencies.KindAndKey kindAndKey = StreamProcessorEvents.parsePath(jr.nextString());
                        if (kindAndKey == null) {
                            return new PatchData(null, null, null);
                        }
                        kind = kindAndKey.kind;
                        key = kindAndKey.key;
                        continue block11;
                    }
                    case "data": {
                        if (kind != null) {
                            dataItem = DataModelSerialization.deserializeFromJsonReader(kind, jr);
                            continue block11;
                        }
                        bufferedParsedData = (JsonElement)JsonHelpers.gsonInstance().fromJson(jr, JsonElement.class);
                        continue block11;
                    }
                }
                jr.skipValue();
            }
            jr.endObject();
            if (kind == null) {
                throw StreamProcessorEvents.missingRequiredProperty("patch", "path");
            }
            if (dataItem == null) {
                if (bufferedParsedData == null) {
                    throw StreamProcessorEvents.missingRequiredProperty("patch", "path");
                }
                dataItem = DataModelSerialization.deserializeFromParsedJson(kind, bufferedParsedData);
            }
            return new PatchData(kind, key, new DataStoreTypes.ItemDescriptor(dataItem.getVersion(), dataItem));
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        catch (RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    static DeleteData parseDeleteData(JsonReader jr) {
        DataStoreTypes.DataKind kind = null;
        String key = null;
        Integer version = null;
        try {
            jr.beginObject();
            block11: while (jr.peek() != JsonToken.END_OBJECT) {
                String prop;
                switch (prop = jr.nextName()) {
                    case "path": {
                        DataModelDependencies.KindAndKey kindAndKey = StreamProcessorEvents.parsePath(jr.nextString());
                        if (kindAndKey == null) {
                            return new DeleteData(null, null, 0);
                        }
                        kind = kindAndKey.kind;
                        key = kindAndKey.key;
                        continue block11;
                    }
                    case "version": {
                        version = jr.nextInt();
                        continue block11;
                    }
                }
                jr.skipValue();
            }
            jr.endObject();
            if (kind == null) {
                throw StreamProcessorEvents.missingRequiredProperty("delete", "path");
            }
            if (version == null) {
                throw StreamProcessorEvents.missingRequiredProperty("delete", "version");
            }
            return new DeleteData(kind, key, version);
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
        catch (RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    private static DataModelDependencies.KindAndKey parsePath(String path) {
        if (path == null) {
            throw new JsonParseException("item path cannot be null");
        }
        for (DataStoreTypes.DataKind kind : DataModel.ALL_DATA_KINDS) {
            String prefix = kind == DataModel.SEGMENTS ? "/segments/" : "/flags/";
            if (!path.startsWith(prefix)) continue;
            return new DataModelDependencies.KindAndKey(kind, path.substring(prefix.length()));
        }
        return null;
    }

    private static JsonParseException missingRequiredProperty(String eventName, String propName) {
        return new JsonParseException(String.format("stream \"{}\" event did not have required property \"{}\"", eventName, propName));
    }

    static final class DeleteData {
        final DataStoreTypes.DataKind kind;
        final String key;
        final int version;

        public DeleteData(DataStoreTypes.DataKind kind, String key, int version) {
            this.kind = kind;
            this.key = key;
            this.version = version;
        }
    }

    static final class PatchData {
        final DataStoreTypes.DataKind kind;
        final String key;
        final DataStoreTypes.ItemDescriptor item;

        PatchData(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
            this.kind = kind;
            this.key = key;
            this.item = item;
        }
    }

    static final class PutData {
        final String path;
        final DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data;

        PutData(String path, DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> data) {
            this.path = path;
            this.data = data;
        }
    }
}

