/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.google.common.collect.Iterables;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.ArrayList;
import java.util.regex.Pattern;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

abstract class Util {
    private static Pattern TAG_VALUE_REGEX = Pattern.compile("^[\\w.-]+$");

    private Util() {
    }

    static final Authenticator okhttpAuthenticatorFromHttpAuthStrategy(final HttpAuthentication strategy) {
        return new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                if (response.request().header("Proxy-Authorization") != null) {
                    return null;
                }
                Iterable challenges = Iterables.transform((Iterable)response.challenges(), c -> new HttpAuthentication.Challenge(c.scheme(), c.realm()));
                String credential = strategy.provideAuthorization(challenges);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
        };
    }

    static String describeDuration(Duration d) {
        if (d.toMillis() % 1000L == 0L) {
            if (d.toMillis() % 60000L == 0L) {
                return d.toMinutes() + (d.toMinutes() == 1L ? " minute" : " minutes");
            }
            long sec = d.toMillis() / 1000L;
            return sec + (sec == 1L ? " second" : " seconds");
        }
        return d.toMillis() + " milliseconds";
    }

    static void deleteDirectory(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String applicationTagHeader(ApplicationInfo applicationInfo, LDLogger logger) {
        String[][] tags = new String[][]{{"applicationId", "application-id", applicationInfo.getApplicationId()}, {"applicationVersion", "application-version", applicationInfo.getApplicationVersion()}};
        ArrayList<String> parts = new ArrayList<String>();
        for (String[] row : tags) {
            String javaKey = row[0];
            String tagKey = row[1];
            String tagVal = row[2];
            if (tagVal == null) continue;
            if (!TAG_VALUE_REGEX.matcher(tagVal).matches()) {
                logger.warn("Value of ApplicationInfo.{} contained invalid characters and was discarded", (Object)javaKey);
                continue;
            }
            if (tagVal.length() > 64) {
                logger.warn("Value of ApplicationInfo.{} was longer than 64 characters and was discarded", (Object)javaKey);
                continue;
            }
            parts.add(tagKey + "/" + tagVal);
        }
        return String.join((CharSequence)" ", parts);
    }
}

