/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.migrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.server.MigrationOp;
import com.launchdarkly.sdk.server.MigrationOpTracker;
import com.launchdarkly.sdk.server.MigrationOrigin;
import com.launchdarkly.sdk.server.MigrationStage;
import com.launchdarkly.sdk.server.MigrationVariation;
import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.migrations.MigrationExecution;
import com.launchdarkly.sdk.server.migrations.MigrationMethodResult;
import com.launchdarkly.sdk.server.migrations.MigrationSerialOrder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Migration<TReadResult, TWriteResult, TReadInput, TWriteInput> {
    private final Reader<TReadInput, TReadResult> readOld;
    private final Reader<TReadInput, TReadResult> readNew;
    private final Writer<TWriteInput, TWriteResult> writeOld;
    private final Writer<TWriteInput, TWriteResult> writeNew;
    private final ReadConsistencyChecker<TReadResult> checker;
    private final MigrationExecution execution;
    private final boolean latencyTracking;
    private final boolean errorTracking;
    private final LDClientInterface client;
    private final LDLogger logger;
    private final ExecutorService pool = Executors.newCachedThreadPool();

    Migration(LDClientInterface client, Reader<TReadInput, TReadResult> readOld, Reader<TReadInput, TReadResult> readNew, Writer<TWriteInput, TWriteResult> writeOld, Writer<TWriteInput, TWriteResult> writeNew, ReadConsistencyChecker<TReadResult> checker, MigrationExecution execution, boolean latencyTracking, boolean errorTracking) {
        this.client = client;
        this.readOld = readOld;
        this.readNew = readNew;
        this.writeOld = writeOld;
        this.writeNew = writeNew;
        this.checker = checker;
        this.execution = execution;
        this.latencyTracking = latencyTracking;
        this.errorTracking = errorTracking;
        this.logger = client.getLogger();
    }

    @NotNull
    private <TInput, TOutput> MigrationResult<TOutput> doSingleOp(@Nullable TInput payload, @NotNull MigrationOpTracker tracker, @NotNull MigrationOrigin origin, @NotNull Method<TInput, TOutput> method) {
        tracker.invoked(origin);
        MigrationMethodResult<TOutput> res = this.trackLatency(payload, tracker, origin, method);
        if (res.isSuccess()) {
            return new MigrationResult<Object>(true, origin, res.getResult().orElse(null), null);
        }
        if (this.errorTracking) {
            tracker.error(origin);
        }
        return new MigrationResult<Object>(false, origin, null, res.getException().orElse(null));
    }

    @NotNull
    private MultiReadResult<TReadResult> doMultiRead(@Nullable TReadInput payload, @NotNull MigrationOpTracker tracker) {
        MultiReadResult<TReadResult> result;
        switch (this.execution.getMode()) {
            case SERIAL: {
                result = this.doSerialRead(payload, tracker);
                break;
            }
            case PARALLEL: {
                result = this.doParallelRead(payload, tracker);
                break;
            }
            default: {
                this.logger.error((Object)"Unrecognized execution mode while executing migration.");
                result = this.doSerialRead(payload, tracker);
            }
        }
        if (this.checker != null && ((MultiReadResult)result).oldResult.success && ((MultiReadResult)result).newResult.success) {
            MigrationResult finalNewResult = ((MultiReadResult)result).newResult;
            MigrationResult finalOldResult = ((MultiReadResult)result).oldResult;
            tracker.consistency(() -> this.checker.check(finalOldResult.result, finalNewResult.result));
        }
        return result;
    }

    @NotNull
    private MultiReadResult<TReadResult> doSerialRead(@Nullable TReadInput payload, @NotNull MigrationOpTracker tracker) {
        MigrationResult<TReadResult> newResult;
        MigrationResult<TReadResult> oldResult;
        MigrationSerialOrder order = this.execution.getOrder().orElse(MigrationSerialOrder.FIXED);
        int result = 0;
        if (order == MigrationSerialOrder.RANDOM) {
            result = ThreadLocalRandom.current().nextInt(2);
        }
        if (result == 0) {
            oldResult = this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.readOld);
            newResult = this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.readNew);
        } else {
            newResult = this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.readNew);
            oldResult = this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.readOld);
        }
        return new MultiReadResult<TReadResult>(oldResult, newResult);
    }

    @NotNull
    private MultiReadResult<TReadResult> doParallelRead(@Nullable TReadInput payload, @NotNull MigrationOpTracker tracker) {
        ArrayList<Callable<MigrationResult>> tasks = new ArrayList<Callable<MigrationResult>>();
        tasks.add(() -> this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.readOld));
        tasks.add(() -> this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.readNew));
        try {
            List futures = this.pool.invokeAll(tasks);
            MigrationResult oldResult = null;
            MigrationResult newResult = null;
            for (Future future : futures) {
                try {
                    MigrationResult result = (MigrationResult)future.get();
                    switch (result.origin) {
                        case OLD: {
                            oldResult = result;
                            break;
                        }
                        case NEW: {
                            newResult = result;
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.error("An error occurred executing parallel reads: {}", (Object)e);
                }
            }
            if (oldResult == null) {
                oldResult = new MigrationResult(false, MigrationOrigin.OLD, null, null);
            }
            if (newResult == null) {
                newResult = new MigrationResult(false, MigrationOrigin.NEW, null, null);
            }
            return new MultiReadResult(oldResult, newResult);
        }
        catch (Exception e) {
            this.logger.error("An error occurred executing parallel reads: {}", (Object)e);
            return new MultiReadResult<Object>(new MigrationResult<Object>(false, MigrationOrigin.OLD, null, null), new MigrationResult<Object>(false, MigrationOrigin.NEW, null, null));
        }
    }

    @NotNull
    private <UInput, UOutput> MigrationMethodResult<UOutput> trackLatency(@Nullable UInput payload, @NotNull MigrationOpTracker tracker, @NotNull MigrationOrigin origin, @NotNull Method<UInput, UOutput> method) {
        MigrationMethodResult<UOutput> res;
        if (this.latencyTracking) {
            long start = System.currentTimeMillis();
            res = Migration.safeCall(payload, method);
            long stop = System.currentTimeMillis();
            tracker.latency(origin, Duration.of(stop - start, ChronoUnit.MILLIS));
        } else {
            res = Migration.safeCall(payload, method);
        }
        return res;
    }

    @NotNull
    private static <UInput, UOutput> MigrationMethodResult<UOutput> safeCall(@Nullable UInput payload, @NotNull Method<UInput, UOutput> method) {
        MigrationMethodResult<Object> res;
        try {
            res = method.execute(payload);
        }
        catch (Exception e) {
            res = MigrationMethodResult.Failure(e);
        }
        return res;
    }

    @NotNull
    private MigrationResult<TReadResult> handleReadStage(@Nullable TReadInput payload, @NotNull MigrationVariation migrationVariation, @NotNull MigrationOpTracker tracker) {
        switch (migrationVariation.getStage()) {
            case OFF: 
            case DUAL_WRITE: {
                return this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.readOld);
            }
            case SHADOW: {
                return this.doMultiRead(payload, tracker).getOld();
            }
            case LIVE: {
                return this.doMultiRead(payload, tracker).getNew();
            }
            case RAMP_DOWN: 
            case COMPLETE: {
                return this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.readNew);
            }
        }
        throw new RuntimeException("Unsupported migration stage.");
    }

    @NotNull
    public MigrationResult<TReadResult> read(@NotNull String key, @NotNull LDContext context, @NotNull MigrationStage defaultStage, @Nullable TReadInput payload) {
        MigrationVariation migrationVariation = this.client.migrationVariation(key, context, defaultStage);
        MigrationOpTracker tracker = migrationVariation.getTracker();
        tracker.op(MigrationOp.READ);
        MigrationResult<TReadResult> res = this.handleReadStage(payload, migrationVariation, tracker);
        this.client.trackMigration(tracker);
        return res;
    }

    @NotNull
    public MigrationResult<TReadResult> read(@NotNull String key, @NotNull LDContext context, @NotNull MigrationStage defaultStage) {
        return this.read(key, context, defaultStage, null);
    }

    @NotNull
    private MigrationWriteResult<TWriteResult> handleWriteStage(@Nullable TWriteInput payload, @NotNull MigrationVariation migrationVariation, @NotNull MigrationOpTracker tracker) {
        switch (migrationVariation.getStage()) {
            case OFF: {
                MigrationResult<TWriteResult> res = this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.writeOld);
                return new MigrationWriteResult<TWriteResult>(res);
            }
            case DUAL_WRITE: 
            case SHADOW: {
                MigrationResult<TWriteResult> oldResult = this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.writeOld);
                if (!((MigrationResult)oldResult).success) {
                    return new MigrationWriteResult<TWriteResult>(oldResult);
                }
                MigrationResult<TWriteResult> newResult = this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.writeNew);
                return new MigrationWriteResult<TWriteResult>(oldResult, newResult);
            }
            case LIVE: 
            case RAMP_DOWN: {
                MigrationResult<TWriteResult> newResult = this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.writeNew);
                if (!((MigrationResult)newResult).success) {
                    return new MigrationWriteResult<TWriteResult>(newResult);
                }
                MigrationResult<TWriteResult> oldResult = this.doSingleOp(payload, tracker, MigrationOrigin.OLD, this.writeOld);
                return new MigrationWriteResult<TWriteResult>(newResult, oldResult);
            }
            case COMPLETE: {
                MigrationResult<TWriteResult> res = this.doSingleOp(payload, tracker, MigrationOrigin.NEW, this.writeNew);
                return new MigrationWriteResult<TWriteResult>(res);
            }
        }
        throw new RuntimeException("Unsupported migration stage.");
    }

    @NotNull
    public MigrationWriteResult<TWriteResult> write(@NotNull String key, @NotNull LDContext context, @NotNull MigrationStage defaultStage, @Nullable TWriteInput payload) {
        MigrationVariation migrationVariation = this.client.migrationVariation(key, context, defaultStage);
        MigrationOpTracker tracker = migrationVariation.getTracker();
        tracker.op(MigrationOp.WRITE);
        MigrationWriteResult<TWriteResult> res = this.handleWriteStage(payload, migrationVariation, tracker);
        this.client.trackMigration(tracker);
        return res;
    }

    @NotNull
    public MigrationWriteResult<TWriteResult> write(@NotNull String key, @NotNull LDContext context, @NotNull MigrationStage defaultStage) {
        return this.write(key, context, defaultStage, null);
    }

    private static final class MultiReadResult<TReadResult> {
        private final MigrationResult<TReadResult> oldResult;
        private final MigrationResult<TReadResult> newResult;

        MultiReadResult(MigrationResult<TReadResult> oldResult, MigrationResult<TReadResult> newResult) {
            this.oldResult = oldResult;
            this.newResult = newResult;
        }

        MigrationResult<TReadResult> getOld() {
            return this.oldResult;
        }

        MigrationResult<TReadResult> getNew() {
            return this.newResult;
        }
    }

    public static final class MigrationWriteResult<TWriteResult> {
        private final MigrationResult<TWriteResult> authoritative;
        private final MigrationResult<TWriteResult> nonAuthoritative;

        public MigrationWriteResult(@NotNull MigrationResult<TWriteResult> authoritative) {
            this.authoritative = authoritative;
            this.nonAuthoritative = null;
        }

        public MigrationWriteResult(@NotNull MigrationResult<TWriteResult> authoritative, @Nullable MigrationResult<TWriteResult> nonAuthoritative) {
            this.authoritative = authoritative;
            this.nonAuthoritative = nonAuthoritative;
        }

        public MigrationResult<TWriteResult> getAuthoritative() {
            return this.authoritative;
        }

        public Optional<MigrationResult<TWriteResult>> getNonAuthoritative() {
            return Optional.ofNullable(this.nonAuthoritative);
        }
    }

    public static final class MigrationResult<TResult> {
        private final boolean success;
        private final MigrationOrigin origin;
        private final TResult result;
        private final Exception exception;

        public MigrationResult(boolean success, @NotNull MigrationOrigin origin, @Nullable TResult result, @Nullable Exception exception) {
            this.success = success;
            this.origin = origin;
            this.result = result;
            this.exception = exception;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public MigrationOrigin getOrigin() {
            return this.origin;
        }

        public Optional<TResult> getResult() {
            return Optional.ofNullable(this.result);
        }

        public Optional<Exception> getException() {
            return Optional.ofNullable(this.exception);
        }
    }

    public static interface ReadConsistencyChecker<TReadResult> {
        public boolean check(TReadResult var1, TReadResult var2);
    }

    public static interface Writer<TWriteInput, TWriteResult>
    extends Method<TWriteInput, TWriteResult> {
    }

    public static interface Reader<TReadInput, TReadResult>
    extends Method<TReadInput, TReadResult> {
    }

    public static interface Method<UInput, UOutput> {
        public MigrationMethodResult<UOutput> execute(UInput var1);
    }
}

