/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.migrations;

import com.launchdarkly.sdk.server.interfaces.LDClientInterface;
import com.launchdarkly.sdk.server.migrations.Migration;
import com.launchdarkly.sdk.server.migrations.MigrationExecution;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> {
    private Migration.Reader<TReadInput, TReadResult> readOld;
    private Migration.Reader<TReadInput, TReadResult> readNew;
    private Migration.Writer<TWriteInput, TWriteResult> writeOld;
    private Migration.Writer<TWriteInput, TWriteResult> writeNew;
    private Migration.ReadConsistencyChecker<TReadResult> checker;
    private MigrationExecution execution = MigrationExecution.Parallel();
    private boolean latencyTracking = true;
    private boolean errorTracking = true;
    private final LDClientInterface client;

    public MigrationBuilder(LDClientInterface client) {
        this.client = client;
    }

    @NotNull
    public MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> trackLatency(boolean track) {
        this.latencyTracking = track;
        return this;
    }

    @NotNull
    public MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> trackErrors(boolean track) {
        this.errorTracking = track;
        return this;
    }

    @NotNull
    public MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> readExecution(MigrationExecution execution) {
        this.execution = execution;
        return this;
    }

    @NotNull
    public MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> read(@NotNull Migration.Reader<TReadInput, TReadResult> oldImpl, @NotNull Migration.Reader<TReadInput, TReadResult> newImpl, @NotNull Migration.ReadConsistencyChecker<TReadResult> checker) {
        this.readOld = oldImpl;
        this.readNew = newImpl;
        this.checker = checker;
        return this;
    }

    @NotNull
    public MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> read(@NotNull Migration.Reader<TReadInput, TReadResult> oldImpl, @NotNull Migration.Reader<TReadInput, TReadResult> newImpl) {
        this.readOld = oldImpl;
        this.readNew = newImpl;
        return this;
    }

    @NotNull
    public MigrationBuilder<TReadResult, TWriteResult, TReadInput, TWriteInput> write(@NotNull Migration.Writer<TWriteInput, TWriteResult> oldImpl, @NotNull Migration.Writer<TWriteInput, TWriteResult> newImpl) {
        this.writeOld = oldImpl;
        this.writeNew = newImpl;
        return this;
    }

    @NotNull
    public Optional<Migration<TReadResult, TWriteResult, TReadInput, TWriteInput>> build() {
        if (this.readNew == null || this.readOld == null || this.writeNew == null || this.writeOld == null) {
            return Optional.empty();
        }
        return Optional.of(new Migration<TReadResult, TWriteResult, TReadInput, TWriteInput>(this.client, this.readOld, this.readNew, this.writeOld, this.writeNew, this.checker, this.execution, this.latencyTracking, this.errorTracking));
    }
}

