/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.migrations;

import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public final class MigrationMethodResult<T> {
    private final boolean success;
    private final T result;
    private final Exception exception;

    private MigrationMethodResult(boolean success, @Nullable T result, @Nullable Exception exception) {
        this.success = success;
        this.result = result;
        this.exception = exception;
    }

    public static <U> MigrationMethodResult<U> Failure() {
        return new MigrationMethodResult<Object>(false, null, null);
    }

    public static <U> MigrationMethodResult<U> Failure(Exception err) {
        return new MigrationMethodResult<Object>(false, null, err);
    }

    public static <U> MigrationMethodResult<U> Success(U result) {
        return new MigrationMethodResult<U>(true, result, null);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Optional<T> getResult() {
        return Optional.ofNullable(this.result);
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }
}

