/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.ftp;

import com.litongjava.utils.file.ConfigUtils;
import com.litongjava.utils.file.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    private static String ftp_server = ConfigUtils.getValue("ftp_server");
    private static Integer ftp_port = Integer.valueOf(ConfigUtils.getValue("ftp_port"));
    private static String ftp_user = ConfigUtils.getValue("ftp_user");
    private static String ftp_password = ConfigUtils.getValue("ftp_password");
    private static FTPClient ftpClient = new FTPClient();
    private static Logger log = LoggerFactory.getLogger(FtpUtils.class);

    private static boolean connecte() {
        boolean connected = ftpClient.isConnected();
        if (!connected) {
            try {
                ftpClient.connect(ftp_server, ftp_port.intValue());
                connected = ftpClient.login(ftp_user, ftp_password);
                ftpClient.setFileType(2);
                ftpClient.enterLocalPassiveMode();
                ftpClient.setControlEncoding("UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return connected;
    }

    private static void disConnect() {
        boolean connected = ftpClient.isConnected();
        if (connected) {
            try {
                ftpClient.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean setWorkDir(String workDir) {
        FtpUtils.connecte();
        boolean retval = false;
        try {
            retval = ftpClient.changeWorkingDirectory(workDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retval;
    }

    public static int mkdir(String folder) {
        FtpUtils.connecte();
        int retval = 0;
        try {
            retval = ftpClient.mkd(folder);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retval;
    }

    private static boolean onlyUpload(String localFile) throws IOException {
        BufferedInputStream bufIns = null;
        boolean isUploadSuccess = false;
        try {
            FileInputStream ins = new FileInputStream(localFile);
            bufIns = new BufferedInputStream(ins);
            isUploadSuccess = ftpClient.storeFile(FileUtils.getFileName(localFile), (InputStream)bufIns);
            if (isUploadSuccess) {
                log.info("file upload success : " + localFile);
            } else {
                log.info("file upload file :" + localFile);
            }
        }
        catch (FileNotFoundException e) {
            FtpUtils.disConnect();
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isUploadSuccess;
    }

    public static boolean upload(String localFile) {
        FtpUtils.connecte();
        boolean isUploadSuccess = false;
        try {
            isUploadSuccess = FtpUtils.onlyUpload(localFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FtpUtils.disConnect();
        return isUploadSuccess;
    }

    public static Map<String, Boolean> upload(List<String> localFiles) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        FtpUtils.connecte();
        for (String localFile : localFiles) {
            boolean b = false;
            try {
                b = FtpUtils.onlyUpload(localFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            retval.put(localFile, b);
        }
        FtpUtils.disConnect();
        return retval;
    }

    public static Map<String, Boolean> uploadFoler(String foler) {
        HashMap<String, Boolean> retval = new HashMap<String, Boolean>();
        String fileName = FileUtils.getFileName(foler);
        FtpUtils.mkdir(fileName);
        FtpUtils.setWorkDir(fileName);
        File[] files = new File(foler).listFiles();
        FtpUtils.connecte();
        for (File file : files) {
            boolean b = false;
            try {
                b = FtpUtils.onlyUpload(file.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            retval.put(file.getAbsolutePath(), b);
        }
        FtpUtils.disConnect();
        return retval;
    }

    static {
        try {
            ftpClient.connect(ftp_server, ftp_port.intValue());
            ftpClient.login(ftp_user, ftp_password);
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setControlEncoding("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int replyCode = ftpClient.getReplyCode();
        log.info("replyCode : " + replyCode);
        if (FTPReply.isPositiveCompletion((int)replyCode)) {
            log.info("connect to ftp success");
        }
    }
}

