/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.common;

import com.loadcoder.load.chart.common.CommonSample;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.jfreechart.XYDataItemExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.sampling.Group;
import com.loadcoder.load.chart.sampling.SampleConcaternator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonSampleGroup
extends Group {
    private static Logger log = LoggerFactory.getLogger(CommonSampleGroup.class);
    XYSeriesExtension series;
    private boolean internalErrorOccured = false;
    Map<Long, CommonSample> commonSamples = new HashMap<Long, CommonSample>();

    public CommonSampleGroup(XYSeriesExtension series) {
        this.series = series;
    }

    public CommonSample getExistingSample(long ts, long sampleLength) {
        long first = CommonSampleGroup.calculateFirstTs(ts, sampleLength);
        CommonSample s = this.commonSamples.get(first);
        return s;
    }

    public void remove(CommonSample s) {
        this.commonSamples.remove(s.getFirstTs());
    }

    public void concaternate(SampleConcaternator concater) {
        long start = concater.getOldRange().getStart();
        Range oldRange = concater.getOldRange();
        long oldSampleLength = oldRange.getSampleLength();
        int amountToConcaternate = concater.getAmountToConcaternate();
        long tsIterator = start;
        for (int i = 0; i < amountToConcaternate; ++i) {
            CommonSample toBeConcaternated = this.getExistingSample(tsIterator, oldSampleLength);
            if (toBeConcaternated != null) {
                XYDataItemExtension first = toBeConcaternated.getFirst();
                if (first == null) {
                    if (!this.internalErrorOccured) {
                        log.warn("An internal problem occured. This has been solved with a workaround.If this crashed your test, please report it to the LoadCoder project at http://loadcoder.com");
                    }
                    this.internalErrorOccured = true;
                } else {
                    this.series.remove(first.getX());
                }
                this.remove(toBeConcaternated);
            }
            tsIterator += oldSampleLength;
        }
        Range newRange = concater.getNewRange();
        long newSampleLength = newRange.getSampleLength();
        this.createCommonSample(start, newSampleLength, 1);
    }

    public CommonSample getAndCreateSample(long ts, Comparable name, long sampleLength) {
        long first = CommonSampleGroup.calculateFirstTs(ts, sampleLength);
        CommonSample s = this.getSample(first, name, sampleLength);
        if (s == null) {
            s = this.createCommonSample(first, sampleLength, 2);
        }
        return s;
    }

    public CommonSample getSample(long first, Comparable name, long sampleLength) {
        CommonSample s = this.fetch(first, sampleLength);
        return s;
    }

    protected CommonSample fetch(long firstTs, long sampleLength) {
        CommonSample s = this.commonSamples.get(firstTs);
        return s;
    }

    private CommonSample createCommonSample(long first, long sampleLength, int created) {
        CommonSample s = new CommonSample(first, sampleLength, created);
        this.commonSamples.put(first, s);
        return s;
    }
}

