/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.jfreechart;

import com.loadcoder.load.LoadUtility;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.jfreechart.ChartPanelExtension;
import com.loadcoder.load.chart.jfreechart.LoadcoderRenderer;
import com.loadcoder.load.chart.jfreechart.XYDottedSeriesExtension;
import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesCollectionExtention;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.menu.AboutPopup;
import com.loadcoder.load.jfreechartfixes.XYLineAndShapeRendererExtention;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartFrame
extends ApplicationFrame {
    private static final long serialVersionUID = 1L;
    public static Logger log = LoggerFactory.getLogger(ChartFrame.class);
    JFrame chartFrame = this;
    private JMenuBar menuBar;
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");
    JFreeChart chart;
    ChartPanel chartPanel;
    XYPlotExtension plot;
    XYLineAndShapeRendererExtention renderer;
    Map<Comparable, Boolean> seriesVisible = new HashMap<Comparable, Boolean>();
    XYSeriesCollectionExtention seriesCollection = new XYSeriesCollectionExtention();
    List<DataSetUser> dataSetUsers = new ArrayList<DataSetUser>();
    JPanel panelForButtons;

    public JFreeChart getChart() {
        return this.chart;
    }

    public XYPlotExtension getPlot() {
        return this.plot;
    }

    public XYLineAndShapeRendererExtention getRenderer() {
        return this.renderer;
    }

    public Map<Comparable, Boolean> getSeriesVisible() {
        return this.seriesVisible;
    }

    public ChartFrame use(DataSetUser dataSetUser) {
        this.dataSetUsers.add(dataSetUser);
        return this;
    }

    public static XYPlotExtension createXYPlotExtension(String yAxisLabel, String xAxisLabel, XYDataset dataset, XYLineAndShapeRendererExtention renderer) {
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        XYPlotExtension plot = new XYPlotExtension(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        return plot;
    }

    public ChartFrame(boolean linesVisible, boolean shapesVisible) {
        super("");
        this.renderer = new LoadcoderRenderer(linesVisible, shapesVisible, this.seriesCollection);
        this.plot = ChartFrame.createXYPlotExtension("X", "Y", (XYDataset)this.seriesCollection, this.renderer);
        this.plot.setRenderer((XYItemRenderer)this.renderer);
        this.plot.getDomainAxis().setAutoRange(true);
        this.plot.getRangeAxis().setAutoRange(true);
        this.showChart();
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 67 && (e.getModifiers() & 2) != 0) {
                    ChartFrame.this.chartPanel.doCopy();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
    }

    XYDataItem xgetDataItem(XYSeriesExtension series, long x) {
        int index = series.indexOf(x);
        XYDataItem existing = (XYDataItem)series.getItems().get(index);
        return existing;
    }

    public XYSeriesCollectionExtention getSeriesCollection() {
        return this.seriesCollection;
    }

    public int getTotalSize() {
        List l = this.seriesCollection.getSeries();
        int totalSize = 0;
        for (Object o : l) {
            XYSeriesExtension series = (XYSeriesExtension)((Object)o);
            int seriesSize = series.getItemCount();
            totalSize += seriesSize;
        }
        return totalSize;
    }

    public static JFreeChart createXYLineChart(String title, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, XYPlot plot) {
        ParamChecks.nullNotPermitted((Object)orientation, (String)"orientation");
        plot.setOrientation(orientation);
        XYItemRenderer renderer = plot.getRenderer();
        if (tooltips) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        currentTheme.apply(chart);
        return chart;
    }

    JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JLabel about = new JLabel("About");
        about.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                AboutPopup.showAboutPopup(ChartFrame.this.chartFrame);
            }
        });
        menuBar.add(about);
        return menuBar;
    }

    public ChartFrame showChart() {
        this.panelForButtons = new JPanel();
        this.panelForButtons.setBackground(Color.WHITE);
        this.panelForButtons.setLayout(new BoxLayout(this.panelForButtons, 3));
        this.chart = ChartFrame.createXYLineChart(null, PlotOrientation.VERTICAL, true, true, false, this.plot);
        this.chartPanel = new ChartPanelExtension(this.chart, 680, 420, 300, 200, 1024, 768, true, false, false, false, false, false, false);
        this.menuBar = this.createMenu();
        this.setJMenuBar(this.menuBar);
        DateAxis dateAxis = new DateAxis();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateAxis.setDateFormatOverride((DateFormat)format);
        this.plot.setDomainAxis((ValueAxis)dateAxis);
        this.chartPanel.addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                int button = e.getTrigger().getButton();
                ChartEntity entity = e.getEntity();
                ChartFrame.this.handleClick(button, entity, ChartFrame.this.seriesCollection);
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        this.chartPanel.setZoomAroundAnchor(true);
        this.panelForButtons.add((Component)this.chartPanel);
        this.panelForButtons.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ChartFrame.this.scrolling(e);
                ChartFrame.this.plot.panDomainAxes(30.0, null, null);
            }
        });
        this.setContentPane(this.panelForButtons);
        this.plot.setDomainGridlinePaint(Color.BLACK);
        this.plot.setRangeGridlinePaint(Color.BLACK);
        this.plot.setBackgroundPaint(Color.WHITE);
        this.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)this));
        return this;
    }

    void setVisibility(XYSeriesExtension clickedSeries, int iterator, LegendItem legend, boolean visible) {
        if (clickedSeries instanceof XYDottedSeriesExtension) {
            this.renderer.setSeriesShapesVisible(iterator, visible);
        } else {
            this.renderer.setSeriesLinesVisible(iterator, visible);
        }
        this.seriesVisible.put(clickedSeries.getKey(), visible);
        clickedSeries.setVisible(visible);
        legend.setLineVisible(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClick(int button, Object clickedObject, XYSeriesCollectionExtention serieses) {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            if (clickedObject instanceof PlotEntity) {
                this.chart.setNotify(false);
                if (button != 1) {
                    this.chartPanel.restoreAutoBounds();
                }
                this.chart.setNotify(true);
                serieses.fireChange();
            } else if (clickedObject instanceof LegendItemEntity) {
                this.chart.setNotify(false);
                LegendItemEntity legendItemEntity = (LegendItemEntity)clickedObject;
                Comparable pushedLegend = legendItemEntity.getSeriesKey();
                List lista = serieses.getSeries();
                int iterator = 0;
                XYSeriesExtension clickedSeries = null;
                for (XYSeriesExtension xy : lista) {
                    Comparable c = xy.getKey();
                    if (pushedLegend.compareTo(c) == 0) {
                        clickedSeries = xy;
                        break;
                    }
                    ++iterator;
                }
                LegendItem clickedLegend = clickedSeries.getLegend();
                if (button == 1) {
                    boolean visible = !clickedSeries.isVisible();
                    this.setVisibility(clickedSeries, iterator, clickedLegend, visible);
                } else {
                    int iterator2 = 0;
                    for (XYSeriesExtension xy : lista) {
                        LegendItem legend = xy.getLegend();
                        boolean visible = false;
                        if (xy.equals((Object)clickedSeries)) {
                            visible = true;
                        }
                        this.setVisibility(xy, iterator2, legend, visible);
                        ++iterator2;
                    }
                }
                this.chart.setNotify(true);
                serieses.fireChange();
            }
        }
    }

    public void copy() {
        this.chartPanel.doCopy();
    }

    void addPanel(JPanel resultChartPanel) {
        this.panelForButtons.add(resultChartPanel);
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void scrolling(MouseWheelEvent e) {
        if (e.getScrollType() != 0) {
            return;
        }
        if (e.getWheelRotation() < 0) {
            this.increaseZoom((JComponent)this.chartPanel, true);
        } else {
            this.decreaseZoom((JComponent)this.chartPanel, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseZoom(JComponent chart, boolean saveAction) {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            ChartPanel ch = (ChartPanel)chart;
            this.zoomChartAxis(ch, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseZoom(JComponent chart, boolean saveAction) {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            ChartPanel ch = (ChartPanel)chart;
            this.zoomChartAxis(ch, false);
        }
    }

    private void zoomChartAxis(ChartPanel chartP, boolean increase) {
        int width = chartP.getMaximumDrawWidth() - chartP.getMinimumDrawWidth();
        int height = chartP.getMaximumDrawHeight() - chartP.getMinimumDrawWidth();
        if (increase) {
            chartP.zoomInBoth((double)(width / 2), (double)(height / 2));
        } else {
            chartP.zoomOutBoth((double)(width / 2), (double)(height / 2));
        }
    }

    public void waitUntilClosed() {
        while (this.isDisplayable()) {
            LoadUtility.sleep((long)1000L);
        }
    }

    public static interface DataSetUser {
        public void useDataSet(List<DataSet> var1);
    }
}

