/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.LoadUtility;
import com.loadcoder.load.chart.common.CommonSampleGroup;
import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.FilteredData;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesCollectionExtention;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.sampling.SampleConcaternator;
import com.loadcoder.load.chart.sampling.SampleConcaternatorRunDecider;
import com.loadcoder.load.chart.sampling.SampleConcaternatorSpec;
import com.loadcoder.load.chart.sampling.SampleGroup;
import com.loadcoder.load.chart.utilities.ChartUtils;
import com.loadcoder.load.chart.utilities.Utilities;
import com.loadcoder.load.jfreechartfixes.XYLineAndShapeRendererExtention;
import com.loadcoder.load.scenario.StartedLoad;
import com.loadcoder.result.TransactionExecutionResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeChartLogic
extends ChartLogic {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<Comparable, XYSeriesExtension> seriesMap = new HashMap<Comparable, XYSeriesExtension>();
    private long[] minmax = new long[]{Long.MAX_VALUE, Long.MIN_VALUE};
    private long firstTsToBeReceived;
    private long tsForFirstUpdateContainingData = Long.MAX_VALUE;
    public List<SampleConcaternator> sampleConcaternatorList = new ArrayList<SampleConcaternator>();
    private Set<Long> sampleTimestamps = new HashSet<Long>();
    long updateTimestamp;
    Map<Comparable, SampleGroup> sampleGroups = new HashMap<Comparable, SampleGroup>();
    protected List<SampleConcaternatorSpec> concaterSpecList = new ArrayList<SampleConcaternatorSpec>();
    Map<Comparable, CommonSampleGroup> samplesCommonMap = new HashMap<Comparable, CommonSampleGroup>();
    List<CommonSampleGroup> sampleGroupCommonList = new ArrayList<CommonSampleGroup>();
    List<List<TransactionExecutionResult>> incomingData;
    protected static final ConcatenationDefinition[] concatenationDefinitions = new ConcatenationDefinition[]{new ConcatenationDefinition(120000L, 4), new ConcatenationDefinition(600000L, 4), new ConcatenationDefinition(2400000L, 4), new ConcatenationDefinition(18000000L, 4), new ConcatenationDefinition(172800000L, 4), new ConcatenationDefinition(864000000L, 8)};

    public void setIncomingData(List<List<TransactionExecutionResult>> incomingData) {
        this.incomingData = incomingData;
    }

    public Map<Comparable, SampleGroup> getSampleGroups() {
        return this.sampleGroups;
    }

    public RuntimeChartLogic(XYSeriesCollectionExtention seriesCollection, XYPlotExtension plot, XYLineAndShapeRendererExtention renderer, Map<Comparable, Boolean> seriesVisible, CommonSeries[] commonSeries, StartedLoad startedScenario, boolean locked) {
        super(seriesCollection, plot, renderer, seriesVisible, locked);
        this.sampleLengthToUse = 1000L;
        this.commonsToBeUsed = commonSeries;
        this.addSampleConcaternatorSpecs(this.concaterSpecList);
        this.createCommons();
        this.addAllCommonSeriesToTheChart();
        this.ranges.add(new Range(Long.MIN_VALUE, -1L, this.sampleLengthToUse));
        this.ranges.add(new Range(0L, Long.MAX_VALUE, this.sampleLengthToUse));
    }

    public int getIncomingSize(List<List<TransactionExecutionResult>> listOfListOfList) {
        int size = 0;
        for (List<TransactionExecutionResult> list : listOfListOfList) {
            size += list.size();
        }
        return size;
    }

    @Override
    protected void getDataAndUpdate(HashSet<Long> hashesGettingUpdated, boolean updateSample) {
        this.update(this.incomingData, hashesGettingUpdated, updateSample);
    }

    public void updateRangesForSampleConcaternatorAfterConcaternation(SampleConcaternator concater) {
        Range oldRange = concater.getOldRange();
        Range newRange = concater.getNewRange();
        long newSampleLength = oldRange.getSampleLength() * (long)concater.getAmountToConcaternate();
        long start = oldRange.getStart();
        long newStart = start + newSampleLength;
        oldRange.setStart(newStart);
        newRange.setEnd(newStart - 1L);
    }

    public void removeFromSampleTimestamps(SampleConcaternator concater, Set<Long> sampleTs) {
        long start = concater.getOldRange().getStart();
        long oldSampleLength = concater.getOldRange().getSampleLength();
        long amount = concater.getAmountToConcaternate();
        long tsToRemove = start;
        int i = 1;
        while ((long)i < amount) {
            sampleTs.remove(tsToRemove += oldSampleLength);
            ++i;
        }
    }

    public void concatAndAdjustRanges(SampleConcaternator concater, Set<Long> hashesGettingUpdated) {
        for (Comparable key : this.seriesKeys) {
            SampleGroup sampleGroup = this.sampleGroups.get(key);
            SampleGroup.ConcaternationResult concaternationResult = sampleGroup.concaternate(concater);
            concaternationResult.fixPointsForSeries(sampleGroup.getSeries());
        }
        for (CommonSampleGroup sampleGroup : this.sampleGroupCommonList) {
            sampleGroup.concaternate(concater);
        }
        this.removeFromSampleTimestamps(concater, this.sampleTimestamps);
        hashesGettingUpdated.add(concater.getOldRange().getStart());
        this.updateRangesForSampleConcaternatorAfterConcaternation(concater);
    }

    public void concat(HashSet<Long> hashesGettingUpdated) {
        long start = System.currentTimeMillis();
        int mostConcatsAtOnce = 1000;
        block0: for (SampleConcaternator concater : this.sampleConcaternatorList) {
            int i = 0;
            while (concater.getSampleConcaternatorRunDecider().timeForConcaternation(concater)) {
                this.concatAndAdjustRanges(concater, hashesGettingUpdated);
                if (i++ <= mostConcatsAtOnce) continue;
                continue block0;
            }
        }
        LoadUtility.logExecutionTime((String)"concatenation", (long)start);
    }

    void performUpdate() {
        HashSet<Long> hashesGettingUpdated = new HashSet<Long>();
        this.concat(hashesGettingUpdated);
        this.getDataAndUpdate(hashesGettingUpdated, true);
        this.addNewSampleConcaternaterIfItsTime();
    }

    @Override
    public void update(List<List<TransactionExecutionResult>> listOfListOfList, HashSet<Long> hashesGettingUpdated, boolean updateSample) {
        this.updateTimestamp = System.currentTimeMillis();
        int incomingSize = this.getIncomingSize(listOfListOfList);
        if (incomingSize == 0) {
            this.updateCommonsWithSamples(hashesGettingUpdated, this.sampleGroups, this.samplesCommonMap, this.sampleGroupCommonList);
            return;
        }
        if (this.tsForFirstUpdateContainingData == Long.MAX_VALUE) {
            this.tsForFirstUpdateContainingData = this.updateTimestamp;
        }
        List resultLists = TransactionExecutionResult.mergeList(listOfListOfList);
        long[] minmaxNew = Utilities.findMinMaxTimestamp(listOfListOfList);
        if (minmaxNew[0] < this.minmax[0]) {
            this.minmax[0] = minmaxNew[0];
        }
        if (minmaxNew[1] > this.minmax[1]) {
            this.minmax[1] = minmaxNew[1];
        }
        if (this.firstTsToBeReceived == 0L) {
            this.firstTsToBeReceived = this.minmax[0];
        }
        long[] minmaxPoints = new long[]{0L, this.minmax[1] - this.minmax[0]};
        List<DataSet> dataSets = Utilities.convert(resultLists, this.firstTsToBeReceived, true);
        this.filteredData = new FilteredData(dataSets, this.minmax, minmaxPoints);
        this.addToSeriesKeys(this.filteredData, this.seriesKeys);
        for (DataSetUserType type : this.removalFiltersInUse) {
            type.getDataSetUser().useDataSet(dataSets);
        }
        this.getSerieses(this.filteredData.getDataSets(), false, this.seriesMap);
        this.addSeriesNotAdded(this.seriesMap);
        this.createSamplesGroups(this.seriesMap, this.sampleGroups);
        this.addPoints(this.filteredData.getDataSets(), this.sampleGroups, this.sampleTimestamps);
        this.updateSeriesWithSamples(ChartUtils.itemSeriesAdderForSamples, hashesGettingUpdated, this.filteredData.getDataSets(), this.sampleGroups, this.sampleTimestamps);
        this.updateCommonsWithSamples(hashesGettingUpdated, this.sampleGroups, this.samplesCommonMap, this.sampleGroupCommonList);
        this.forceRerender();
    }

    private void addSeriesNotAdded(Map<Comparable, XYSeriesExtension> seriesMap) {
        for (Comparable key : this.seriesKeys) {
            if (this.sampleGroups.get(key) != null) continue;
            XYSeriesExtension series = seriesMap.get(key);
            this.addSeries(series);
        }
    }

    public void addNewConcater(int amountOfSamplesToConcaternate, SampleConcaternatorRunDecider sampleConcaternatorRunDecider) {
        Range oldRange = (Range)this.ranges.get(this.ranges.size() - 1);
        long newSampleLength = oldRange.getSampleLength() * (long)amountOfSamplesToConcaternate;
        Range newRange = new Range(0L, -1L, newSampleLength);
        this.ranges.add(newRange);
        SampleConcaternator sampleConcaternator = new SampleConcaternator(oldRange, newRange, amountOfSamplesToConcaternate, sampleConcaternatorRunDecider);
        this.sampleConcaternatorList.add(sampleConcaternator);
    }

    public void addNewSampleConcaternaterIfItsTime() {
        SampleConcaternatorSpec s;
        long howLongAfterStart;
        if (!this.concaterSpecList.isEmpty() && !this.ranges.isEmpty() && this.updateTimestamp - (howLongAfterStart = (s = this.concaterSpecList.get(0)).getHowLongAfterStartShouldThisBeAdded()) > this.tsForFirstUpdateContainingData) {
            this.logger.debug("Starting a new concater: {}", (Object)s);
            this.concaterSpecList.remove(0);
            this.addNewConcater(s.getAmoutThatShouldBeConcaternated(), s.getSampleConcaternatorRunDecider());
        }
    }

    protected static SampleConcaternatorSpec getNewSpec(ConcatenationDefinition def) {
        int amountToConcat = def.amountToConcatenate;
        long minSizeOfOldRane = def.width;
        return new SampleConcaternatorSpec(minSizeOfOldRane, amountToConcat, a -> {
            long minSizeOfOldRange2 = minSizeOfOldRane;
            Range newRange = a.getNewRange();
            Range oldRange = a.getOldRange();
            long endOfTheNewRange = newRange.getEnd();
            long endOfTheOldRange = oldRange.getEnd();
            long diff = endOfTheOldRange - endOfTheNewRange;
            return diff > minSizeOfOldRange2;
        });
    }

    SampleConcaternatorRunDecider getFirstConcaterRunDecider(long widthOfUnconcatenatedRange) {
        SampleConcaternatorRunDecider firstConcater = a -> {
            Long higest = this.highestX;
            long startOfOldRange = a.getOldRange().getStart();
            return higest > startOfOldRange + widthOfUnconcatenatedRange;
        };
        return firstConcater;
    }

    public void addSampleConcaternatorSpecs(List<SampleConcaternatorSpec> concaterSpecs) {
        concaterSpecs.add(new SampleConcaternatorSpec(RuntimeChartLogic.concatenationDefinitions[0].width, RuntimeChartLogic.concatenationDefinitions[0].amountToConcatenate, this.getFirstConcaterRunDecider(RuntimeChartLogic.concatenationDefinitions[0].width)));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(concatenationDefinitions[1]));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(concatenationDefinitions[2]));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(concatenationDefinitions[3]));
        concaterSpecs.add(RuntimeChartLogic.getNewSpec(concatenationDefinitions[4]));
    }

    public void calculateAmountOfPoints() {
        int amountOfSerieses = 10;
        int amountOfPointsPerSamples = 2;
        long testExecution = 2592000000L;
        long sampleLengthDefault = 1000L;
        int totalAmountOfPoints = 0;
        long executionTimeLeft = testExecution;
        long sampleLengthUsedForThisWidth = sampleLengthDefault;
        for (ConcatenationDefinition d : concatenationDefinitions) {
            if (executionTimeLeft < 1L) break;
            long widthForThis = 0L;
            widthForThis = executionTimeLeft < d.width ? executionTimeLeft : (d.equals(concatenationDefinitions[concatenationDefinitions.length - 1]) ? executionTimeLeft : d.width);
            executionTimeLeft -= widthForThis;
            int amountOfSamplesForOneSeries = (int)(widthForThis / sampleLengthUsedForThisWidth);
            int amountOfSamplesTotal = amountOfSamplesForOneSeries * amountOfSerieses;
            int pointsForThisRange = amountOfSamplesTotal * amountOfPointsPerSamples;
            totalAmountOfPoints += pointsForThisRange;
            sampleLengthUsedForThisWidth *= (long)d.amountToConcatenate;
        }
        this.logger.trace(String.format("total points:%s", totalAmountOfPoints));
    }

    @Override
    protected void doUpdate() {
        this.performUpdate();
    }

    protected static class ConcatenationDefinition {
        long width;
        int amountToConcatenate;

        public ConcatenationDefinition(long widthOfPreviousRangeBeforeConcatenation, int amountToConcatenate) {
            this.width = widthOfPreviousRangeBeforeConcatenation;
            this.amountToConcatenate = amountToConcatenate;
        }
    }
}

