/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.common;

import com.loadcoder.load.chart.data.Point;
import java.util.List;

public abstract class YCalculator {
    public static final YCalculator avg = new YCalculator(){

        @Override
        public double calculateY(List<Point> points) {
            double y = 0.0;
            int amountUsed = 0;
            for (Point point : points) {
                if (!point.isEnabled()) continue;
                y += (double)point.getY();
                ++amountUsed;
            }
            if (amountUsed == 0) {
                return -1.0;
            }
            return y /= (double)amountUsed;
        }

        @Override
        public String getName() {
            return "Average";
        }
    };
    public static final YCalculator max = new YCalculator(){

        @Override
        public double calculateY(List<Point> points) {
            long max = -1L;
            for (Point point : points) {
                if (!point.isEnabled() || point.getY() <= max) continue;
                max = point.getY();
            }
            return max;
        }

        @Override
        public String getName() {
            return "Max";
        }
    };

    public abstract String getName();

    public abstract double calculateY(List<Point> var1);
}

