/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.jfreechart;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XYPlotExtension
extends XYPlot {
    private static final long serialVersionUID = 1L;
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    XYDataset dataset;
    private final SimpleDateFormat monthDayDateFormat = new SimpleDateFormat("MM-dd HH:mm:ss");
    XYItemRenderer renderer = this.getRenderer(0);
    LegendItemCollection legends = new LegendItemCollection();

    public XYPlotExtension(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, XYItemRenderer renderer) {
        super(dataset, domainAxis, rangeAxis, renderer);
        this.dataset = dataset;
    }

    public long getXRange() {
        ValueAxis xAxis = this.getDomainAxisForDataset(0);
        double diff = xAxis.getUpperBound() - xAxis.getLowerBound();
        return (long)diff;
    }

    public void changeToMonthAndDayDateAxisFormat() {
        ((DateAxis)this.getDomainAxis()).setDateFormatOverride((DateFormat)this.monthDayDateFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render(Graphics2D g2, Rectangle2D dataArea, int index, PlotRenderingInfo info, CrosshairState crosshairState) {
        boolean result = false;
        XYPlotExtension xYPlotExtension = this;
        synchronized (xYPlotExtension) {
            long start = System.currentTimeMillis();
            result = super.render(g2, dataArea, index, info, crosshairState);
            this.logger.debug("Render time: {} ms", (Object)(System.currentTimeMillis() - start));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomDomainAxes(double factor, PlotRenderingInfo info, Point2D source) {
        XYPlotExtension xYPlotExtension = this;
        synchronized (xYPlotExtension) {
            super.zoomDomainAxes(factor, info, source);
        }
    }

    public LegendItemCollection getLegends() {
        return this.legends;
    }

    public LegendItemCollection getLegendItems() {
        return this.getLegends();
    }
}

