/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.jfreechart.ChartFrame;
import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.menu.AboutPopup;
import com.loadcoder.load.chart.menu.MouseClickedListener;
import com.loadcoder.load.chart.menu.settings.SettingsWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenu;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;

public abstract class Chart {
    ChartFrame chartFrame;
    protected final Map<String, Color> existingColors = new HashMap<String, Color>();
    final ChartLogic logic;

    public Chart(boolean linesVisible, boolean shapesVisible, ChartLogic logic) {
        this.logic = logic;
        Toolkit.getDefaultToolkit().setDynamicLayout(false);
        this.chartFrame = new ChartFrame(linesVisible, shapesVisible, this.existingColors, logic);
        Stroke[] strokes = new Stroke[]{new BasicStroke()};
        DefaultDrawingSupplier newSup = new DefaultDrawingSupplier(null, new Paint[0], strokes, strokes, new Shape[]{new Rectangle(new Dimension(8, 8))});
        logic.getPlot().setDrawingSupplier((DrawingSupplier)newSup);
    }

    public void waitUntilClosed() {
        this.chartFrame.waitUntilClosed();
    }

    JMenu createAboutMenu() {
        JMenu about = new JMenu("About");
        about.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                AboutPopup.showAboutPopup((JFrame)((Object)Chart.this.chartFrame));
            }
        });
        return about;
    }

    JMenu createSettingsMenu(final ChartLogic logic) {
        JMenu settings = new JMenu("Settings");
        settings.addMouseListener(new MouseClickedListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                new SettingsWindow(Chart.this.chartFrame, "Settings", logic);
            }
        });
        return settings;
    }

    protected Chart use(ChartFrame.DataSetUser dataSetUser) {
        this.chartFrame.use(dataSetUser);
        return this;
    }

    protected XYPlotExtension getPlot() {
        return this.chartFrame.getPlot();
    }
}

