/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.common.CommonSample;
import com.loadcoder.load.chart.common.CommonSampleGroup;
import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.common.CommonSeriesCalculator;
import com.loadcoder.load.chart.common.CommonYCalculator;
import com.loadcoder.load.chart.common.YCalculator;
import com.loadcoder.load.chart.data.DataSet;
import com.loadcoder.load.chart.data.FilteredData;
import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.data.Range;
import com.loadcoder.load.chart.data.Ranges;
import com.loadcoder.load.chart.jfreechart.ChartPanelExtension;
import com.loadcoder.load.chart.jfreechart.LoadcoderRenderer;
import com.loadcoder.load.chart.jfreechart.XYDottedSeriesExtension;
import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesCollectionExtention;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.RuntimeChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.sampling.Sample;
import com.loadcoder.load.chart.sampling.SampleGroup;
import com.loadcoder.load.chart.utilities.ChartUtils;
import com.loadcoder.load.chart.utilities.ColorUtils;
import com.loadcoder.load.jfreechartfixes.DateAxisExtension;
import com.loadcoder.load.jfreechartfixes.XYLineAndShapeRendererExtention;
import com.loadcoder.result.TransactionExecutionResult;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.LegendItemEntity;
import org.jfree.chart.entity.PlotEntity;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChartLogic {
    Logger log = LoggerFactory.getLogger(ChartLogic.class);
    private final Map<String, XYSeriesExtension> commonSeriesMap = new HashMap<String, XYSeriesExtension>();
    private final CommonSeries[] commonsToBeUsed;
    protected Long earliestX;
    protected long highestX = 0L;
    private long sampleLengthToUse;
    final boolean locked;
    private FilteredData filteredData;
    private List<DataSetUserType> removalFiltersInUse = new ArrayList<DataSetUserType>();
    protected final XYSeriesCollectionExtention seriesCollection;
    protected final XYPlotExtension plot;
    protected final XYLineAndShapeRendererExtention renderer;
    protected final Map<String, Boolean> seriesVisible = new HashMap<String, Boolean>();
    protected final List<YCalculator> yCalculators = new ArrayList<YCalculator>();
    public YCalculator yCalculatorToUse = YCalculator.avg;
    private final Map<String, Color> existingColors;
    public static final int TARGET_AMOUNT_OF_POINTS_DEFAULT = 20000;
    protected static final long SAMPLELENGTH_DEFAULT = 1000L;
    @Deprecated
    Map<String, Color> customizedColors;
    private final List<String> seriesKeys = new ArrayList<String>();
    protected final Map<String, LegendItem> legends = new HashMap<String, LegendItem>();
    protected final List<CommonSeriesCalculator> commonSeriesCalculators = new ArrayList<CommonSeriesCalculator>();
    Ranges ranges = new Ranges();
    public final List<Color> blacklistColors = new ArrayList<Color>();
    JPanel panelForButtons;
    private JMenuBar menuBar = new JMenuBar();
    private static final ChartTheme currentTheme = new StandardChartTheme("JFree");
    final JFreeChart chart;
    final ChartPanel chartPanel;
    public static final int MOUSE_LEFT_CLICK_CODE = 1;

    public ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public Ranges getRanges() {
        return this.ranges;
    }

    public ChartLogic(CommonSeries[] commonSeries, boolean locked) {
        this.locked = locked;
        this.seriesCollection = new XYSeriesCollectionExtention();
        HashMap<String, Color> existingColors = new HashMap<String, Color>();
        this.renderer = new LoadcoderRenderer(true, false, this.seriesCollection, existingColors);
        this.commonsToBeUsed = commonSeries == null ? CommonSeries.values() : commonSeries;
        this.existingColors = existingColors;
        for (CommonSeries s : this.commonsToBeUsed) {
            existingColors.put(s.getName(), s.getColor());
        }
        this.plot = RuntimeChartLogic.createXYPlotExtension("y", "x", (XYDataset)this.seriesCollection, this.renderer);
        this.chart = ChartLogic.createXYLineChart(null, true, true, false, this.plot);
        this.chartPanel = new ChartPanelExtension(this.chart, 680, 420, 300, 200, 1024, 768, true, false, false, false, false, false, false);
        this.initCommonSeries();
        this.yCalculators.add(YCalculator.avg);
        this.yCalculators.add(YCalculator.max);
        ColorUtils.defaultBlacklistColors.stream().forEach(blackListed -> this.blacklistColors.add((Color)blackListed));
    }

    public static JFreeChart createXYLineChart(String title, boolean legend, boolean tooltips, boolean urls, XYPlot plot) {
        XYItemRenderer renderer = plot.getRenderer();
        if (tooltips) {
            renderer.setBaseToolTipGenerator((XYToolTipGenerator)new StandardXYToolTipGenerator());
        }
        if (urls) {
            renderer.setURLGenerator((XYURLGenerator)new StandardXYURLGenerator());
        }
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        currentTheme.apply(chart);
        return chart;
    }

    public static XYPlotExtension createXYPlotExtension(String yAxisLabel, String xAxisLabel, XYDataset dataset, XYLineAndShapeRendererExtention renderer) {
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        XYPlotExtension plot = new XYPlotExtension(dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)renderer);
        plot.setRenderer((XYItemRenderer)renderer);
        plot.getDomainAxis().setAutoRange(true);
        plot.getRangeAxis().setAutoRange(true);
        return plot;
    }

    protected List<String> getSeriesKeys() {
        return this.seriesKeys;
    }

    protected void addSeriesKey(String key) {
        if (!this.seriesKeys.contains(key)) {
            this.seriesKeys.add(key);
        }
    }

    protected Map<String, XYSeriesExtension> getCommonSeriesMap() {
        return this.commonSeriesMap;
    }

    protected abstract void update(Map<String, List<TransactionExecutionResult>> var1, HashSet<Long> var2);

    protected abstract void doUpdate();

    public YCalculator getYCalculatorToUse() {
        return this.yCalculatorToUse;
    }

    public XYSeriesCollectionExtention getSeriesCollection() {
        return this.seriesCollection;
    }

    public Map<String, Color> getExistingColors() {
        return this.existingColors;
    }

    public XYPlotExtension getPlot() {
        return this.plot;
    }

    protected long getXDiff() {
        if (this.earliestX == null) {
            return 0L;
        }
        long xDiff = this.highestX - this.earliestX;
        return xDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSafeUpdate() {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            this.doUpdate();
            long xDiff = this.getXDiff();
            if (xDiff > 82800000L) {
                this.plot.changeToMonthAndDayDateAxisFormat();
            }
        }
    }

    public List<DataSetUserType> getRemovalFiltersInUse() {
        return this.removalFiltersInUse;
    }

    protected void setFilteredData(FilteredData filteredData) {
        this.filteredData = filteredData;
    }

    public FilteredData getFilteredData() {
        return this.filteredData;
    }

    public long getSampleLengthToUse() {
        return this.sampleLengthToUse;
    }

    public void setSampleLengthToUse(long sampleLengthToUse) {
        this.sampleLengthToUse = sampleLengthToUse;
    }

    public List<YCalculator> getyCalculators() {
        return this.yCalculators;
    }

    void addToSeriesKeys(FilteredData filteredData, List<String> seriesKeys) {
        for (DataSet dataSet : filteredData.getDataSets()) {
            String s = dataSet.getName();
            if (seriesKeys.contains(s)) continue;
            seriesKeys.add(s);
        }
    }

    public void initCommonSeries() {
        this.createCommons();
        this.addAllCommonSeriesToTheChart();
    }

    public void initiateChart() {
        PlotOrientation orientation = PlotOrientation.VERTICAL;
        ParamChecks.nullNotPermitted((Object)orientation, (String)"orientation");
        this.plot.setOrientation(orientation);
        this.panelForButtons = new JPanel();
        this.panelForButtons.setBackground(Color.WHITE);
        this.panelForButtons.setLayout(new BoxLayout(this.panelForButtons, 3));
        DateAxisExtension dateAxis = new DateAxisExtension();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        dateAxis.setDateFormatOverride((DateFormat)format);
        this.plot.setDomainAxis((ValueAxis)dateAxis);
        this.getChartPanel().addChartMouseListener(new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent e) {
                int button = e.getTrigger().getButton();
                ChartEntity entity = e.getEntity();
                XYSeriesCollectionExtention collection = (XYSeriesCollectionExtention)ChartLogic.this.plot.getDataset();
                ChartLogic.this.handleClick(button, entity, collection);
            }

            public void chartMouseMoved(ChartMouseEvent e) {
            }
        });
        this.getChartPanel().setPreferredSize(new Dimension(500, 270));
        this.getChartPanel().setZoomAroundAnchor(true);
        this.panelForButtons.add((Component)this.getChartPanel());
        this.panelForButtons.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ChartLogic.this.scrolling(e);
                ChartLogic.this.plot.panDomainAxes(30.0, null, null);
            }
        });
        this.plot.setDomainGridlinePaint(Color.BLACK);
        this.plot.setRangeGridlinePaint(Color.BLACK);
        this.plot.setBackgroundPaint(Color.WHITE);
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void scrolling(MouseWheelEvent e) {
        if (e.getScrollType() != 0) {
            return;
        }
        if (e.getWheelRotation() < 0) {
            this.increaseZoom((JComponent)this.getChartPanel(), true);
        } else {
            this.decreaseZoom((JComponent)this.getChartPanel(), true);
        }
    }

    private void zoomChartAxis(ChartPanel chartP, boolean increase) {
        int width = chartP.getMaximumDrawWidth() - chartP.getMinimumDrawWidth();
        int height = chartP.getMaximumDrawHeight() - chartP.getMinimumDrawWidth();
        if (increase) {
            chartP.zoomInBoth((double)(width / 2), (double)(height / 2));
        } else {
            chartP.zoomOutBoth((double)(width / 2), (double)(height / 2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseZoom(JComponent chart, boolean saveAction) {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            ChartPanel ch = (ChartPanel)chart;
            this.zoomChartAxis(ch, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseZoom(JComponent chart, boolean saveAction) {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            ChartPanel ch = (ChartPanel)chart;
            this.zoomChartAxis(ch, false);
        }
    }

    public void setVisibility(XYSeriesExtension clickedSeries, int iterator, LegendItem legend, boolean visible) {
        if (clickedSeries instanceof XYDottedSeriesExtension) {
            this.renderer.setSeriesShapesVisible(iterator, visible);
        } else {
            this.renderer.setSeriesLinesVisible(iterator, visible);
        }
        this.seriesVisible.put(clickedSeries.getKey(), visible);
        clickedSeries.setVisible(visible);
        legend.setShapeVisible(visible);
    }

    public static void addSurroundingTimestampsAsUpdates(Set<Long> hashesGettingUpdated, long sampleStart, long earliest, long latest, Ranges ranges, long currentSampleLength, Set<Long> sampleTimestamps, Map<Long, Sample> aboutToBeUpdated) {
        long iterator = sampleStart;
        while (earliest < iterator) {
            long lastTsInPrevious = iterator - 1L;
            long sampleLength = ranges.findSampleLength(lastTsInPrevious);
            long firstTsInPrevious = SampleGroup.calculateFirstTs(lastTsInPrevious, sampleLength);
            boolean exists = false;
            if (sampleTimestamps.contains(firstTsInPrevious) || aboutToBeUpdated.containsKey(firstTsInPrevious)) {
                exists = true;
            }
            if (exists) break;
            if (!hashesGettingUpdated.contains(firstTsInPrevious)) {
                hashesGettingUpdated.add(firstTsInPrevious);
            }
            iterator = firstTsInPrevious;
        }
        iterator = sampleStart;
        while (latest > iterator) {
            long sampleLength = ranges.findSampleLength(iterator);
            long firstTsInNext = iterator + sampleLength;
            boolean exists = false;
            if (sampleTimestamps.contains(firstTsInNext) || aboutToBeUpdated.containsKey(firstTsInNext)) {
                exists = true;
            }
            if (exists) break;
            if (!hashesGettingUpdated.contains(firstTsInNext)) {
                hashesGettingUpdated.add(firstTsInNext);
            }
            iterator = firstTsInNext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClick(int button, Object clickedObject, XYSeriesCollectionExtention serieses) {
        XYPlotExtension xYPlotExtension = this.plot;
        synchronized (xYPlotExtension) {
            if (clickedObject instanceof PlotEntity || clickedObject instanceof LegendItemEntity) {
                this.chart.setNotify(false);
                if (clickedObject instanceof PlotEntity) {
                    if (button != 1) {
                        this.chartPanel.restoreAutoBounds();
                    }
                } else if (clickedObject instanceof LegendItemEntity) {
                    LegendItemEntity legendItemEntity = (LegendItemEntity)clickedObject;
                    Comparable pushedLegend = legendItemEntity.getSeriesKey();
                    List lista = serieses.getSeries();
                    int iterator = 0;
                    XYSeriesExtension clickedSeries = null;
                    for (XYSeriesExtension xy : lista) {
                        String c = xy.getKey();
                        if (pushedLegend.compareTo(c) == 0) {
                            clickedSeries = xy;
                            break;
                        }
                        ++iterator;
                    }
                    LegendItem clickedLegend = clickedSeries.getLegend();
                    if (button == 1) {
                        boolean visible = !clickedSeries.isVisible();
                        this.setVisibility(clickedSeries, iterator, clickedLegend, visible);
                    } else {
                        int legendIndexIterator = 0;
                        if (clickedSeries.isVisible()) {
                            boolean isAllSeriesVisible = true;
                            for (XYSeriesExtension xy : lista) {
                                if (xy.isVisible()) continue;
                                isAllSeriesVisible = false;
                            }
                            if (isAllSeriesVisible) {
                                this.disableAllLegendsExceptOne(clickedSeries, lista);
                            } else {
                                for (XYSeriesExtension xy : lista) {
                                    LegendItem legend = xy.getLegend();
                                    boolean visible = true;
                                    this.setVisibility(xy, legendIndexIterator, legend, visible);
                                    ++legendIndexIterator;
                                }
                            }
                        } else {
                            this.disableAllLegendsExceptOne(clickedSeries, lista);
                        }
                    }
                }
                this.chart.setNotify(true);
                serieses.fireChange();
            }
        }
    }

    private void disableAllLegendsExceptOne(XYSeriesExtension clickedSeries, List<XYSeriesExtension> lista) {
        int legendIndexIterator = 0;
        for (XYSeriesExtension xy : lista) {
            LegendItem legend = xy.getLegend();
            boolean visible = false;
            if (xy.equals((Object)clickedSeries)) {
                visible = true;
            }
            this.setVisibility(xy, legendIndexIterator, legend, visible);
            ++legendIndexIterator;
        }
    }

    public void createCommons() {
        Arrays.stream(this.commonsToBeUsed).forEach(common -> {
            Color c = this.existingColors.get(common.getName());
            if (c == null) {
                c = common.getColor();
            }
            XYSeriesExtension xySeries = new XYSeriesExtension(common.getName(), true, false, c);
            this.commonSeriesMap.put(common.getName(), xySeries);
            this.commonSeriesCalculators.add(new CommonSeriesCalculator(xySeries, common.getCommonYCalculator()));
        });
    }

    public void addSeries(XYSeriesExtension serie) {
        this.seriesCollection.addSeries(serie);
        int indexOfSeries = this.seriesCollection.indexOf(serie);
        LegendItem legend = this.legends.get(serie.getKey());
        if (legend == null) {
            legend = this.plot.getRenderer().getLegendItem(0, indexOfSeries);
            Color c = this.existingColors.get(serie.getKey());
            legend.setFillPaint((Paint)c);
            legend.setShapeVisible(true);
            legend.setLineVisible(false);
            this.legends.put(serie.getKey(), legend);
            this.plot.getLegendItems().add(legend);
        }
        serie.setLegend(legend);
    }

    public void removeSeries(XYSeriesExtension serie) {
        int indexOfSeries = this.seriesCollection.indexOf(serie);
        this.seriesCollection.removeSeries(indexOfSeries);
    }

    void updateCommonsWithSamples(HashSet<Long> hashesGettingUpdated, Map<String, SampleGroup> sampleGroups, Map<String, CommonSampleGroup> samplesCommonMap, List<CommonSampleGroup> sampleGroupCommonList) {
        for (Long l : hashesGettingUpdated) {
            for (CommonSeriesCalculator calc : this.commonSeriesCalculators) {
                XYSeriesExtension series = calc.getSeries();
                CommonYCalculator calculator = calc.getCalculator();
                Range r = this.ranges.lookupCorrectRange(l);
                double amount = calculator.calculateCommonY(this.seriesKeys, l, sampleGroups, r.getSampleLength());
                String commonKey = series.getKey();
                CommonSampleGroup commonSampleGroup = samplesCommonMap.get(commonKey);
                if (commonSampleGroup == null) {
                    commonSampleGroup = new CommonSampleGroup(series);
                    samplesCommonMap.put(commonKey, commonSampleGroup);
                    sampleGroupCommonList.add(commonSampleGroup);
                }
                CommonSample cs = commonSampleGroup.getAndCreateSampleAndPutInMap(l, r.getSampleLength());
                long longAmount = Sample.amountToYValue(amount);
                cs.setY(longAmount);
                if (cs.getFirst() == null) {
                    cs.initDataItems();
                    series.add(cs.getFirst(), false);
                    continue;
                }
                cs.updateDataItems();
            }
        }
    }

    Paint getSeriesColor(String dataSetName) {
        LegendItem legend = this.legends.get(dataSetName);
        Paint seriesColor = null;
        seriesColor = legend == null ? this.getNewColor(dataSetName) : legend.getFillPaint();
        return seriesColor;
    }

    void getSerieses(List<DataSet> dataSets, Map<String, XYSeriesExtension> seriesMap) {
        for (DataSet dataSet : dataSets) {
            String dataSetName = dataSet.getName();
            Paint seriesColor = this.getSeriesColor(dataSetName);
            XYSeriesExtension seriesName = seriesMap.get(dataSetName);
            if (seriesName != null) continue;
            XYSeriesExtension serie = new XYSeriesExtension(dataSetName, true, false, seriesColor);
            seriesMap.put(dataSetName, serie);
        }
    }

    void adjustVisibilityOfSeries(XYSeriesExtension serie) {
        int indexOfSeries = this.seriesCollection.indexOf(serie);
        this.renderer.setSeriesShape(indexOfSeries, XYDottedSeriesExtension.DOTTEDSHAPE);
        Boolean visible = this.seriesVisible.get(serie.getKey());
        if (visible == null) {
            visible = true;
            this.seriesVisible.put(serie.getKey(), visible);
        }
        serie.setVisible(visible);
        serie.getLegend().setShapeVisible(visible.booleanValue());
        this.renderer.setSeriesLinesVisible(indexOfSeries, visible);
        this.renderer.setSeriesShapesVisible(indexOfSeries, false);
    }

    void addPoints(List<DataSet> dataSets, Map<String, SampleGroup> sampleGroups, Set<Long> sampleTimestamps) {
        for (DataSet dataSet : dataSets) {
            String dataSetName = dataSet.getName();
            SampleGroup sampleGroup = sampleGroups.get(dataSetName);
            this.createSamplesAndAddPoints(dataSetName, sampleGroup.getSeries(), dataSet, sampleGroup, sampleTimestamps);
        }
    }

    void createSamplesGroups(Map<String, XYSeriesExtension> seriesMap, Map<String, SampleGroup> sampleGroups) {
        for (String key : this.seriesKeys) {
            XYSeriesExtension serie = seriesMap.get(key);
            SampleGroup sampleGroup = sampleGroups.get(key);
            if (sampleGroup != null) continue;
            sampleGroup = new SampleGroup(this.sampleLengthToUse, serie, this.locked);
            sampleGroups.put(key, sampleGroup);
        }
    }

    void createSamplesAndAddPoints(String dataSetName, XYSeriesExtension serie, DataSet dataSet, SampleGroup sampleGroup, Set<Long> sampleTimestamps) {
        for (Point point : dataSet.getPoints()) {
            long x = point.getX();
            if (x > this.highestX) {
                this.highestX = x;
            }
            if (this.earliestX == null || x < this.earliestX) {
                this.earliestX = x;
                if (this.ranges.isRangesEmpty()) {
                    Sample s = sampleGroup.getAndCreateSample(point.getX(), dataSetName, this.sampleLengthToUse);
                    this.ranges.addRange(new Range(s.getFirstTs(), Long.MAX_VALUE, this.sampleLengthToUse));
                } else {
                    Range r = this.ranges.lookupCorrectRange(x);
                    if (r == null) {
                        r = this.ranges.getLastRange();
                    }
                    long sampleLengthOfTheLastAddedRange = r.getSampleLength();
                    Sample s = sampleGroup.getAndCreateSample(x, dataSetName, sampleLengthOfTheLastAddedRange);
                    r.setStart(s.getFirstTs());
                }
            }
            Range rangeToUse = this.ranges.lookupCorrectRange(x);
            Sample s = sampleGroup.getAndCreateSample(point.getX(), dataSetName, rangeToUse.getSampleLength());
            if (!sampleTimestamps.contains(s.getFirstTs())) {
                sampleTimestamps.add(s.getFirstTs());
            }
            s.addPoint(point);
            if (!point.isStatus()) {
                s.increaseFails();
            }
            if (sampleGroup.getSamplesUnupdated().containsKey(s.getFirstTs())) continue;
            sampleGroup.getSamplesUnupdated().put(s.getFirstTs(), s);
        }
    }

    public void addAllCommonSeriesToTheChart() {
        for (XYSeriesExtension series : this.getCommonSeriesMap().values()) {
            this.addSeries(series);
            int indexOfSeries = this.seriesCollection.indexOf(series);
            Boolean visible = this.seriesVisible.get(series.getKey());
            if (visible == null || visible.booleanValue()) {
                this.renderer.setSeriesLinesVisible(indexOfSeries, true);
            } else {
                this.renderer.setSeriesLinesVisible(indexOfSeries, false);
            }
            this.renderer.setSeriesShapesVisible(indexOfSeries, false);
        }
    }

    public int getTotalSize() {
        List l = this.seriesCollection.getSeries();
        int totalSize = 0;
        for (Object o : l) {
            XYSeriesExtension series = (XYSeriesExtension)((Object)o);
            int seriesSize = series.getItemCount();
            totalSize += seriesSize;
        }
        return totalSize;
    }

    public synchronized Color getNewColor(String seriesKey) {
        HashSet<Color> set = new HashSet<Color>(this.existingColors.values());
        Color newColor = ColorUtils.getNewContrastfulColor(set, this.blacklistColors);
        this.existingColors.put(seriesKey, newColor);
        return newColor;
    }

    public void forceRerender() {
        this.seriesCollection.fireChange();
    }

    void updateSeriesWithSamples(Set<Long> hashesGettingUpdated, List<DataSet> dataSets, Map<String, SampleGroup> sampleGroups, Set<Long> sampleTimestamps, boolean dottedMode) {
        for (String key : this.seriesKeys) {
            SampleGroup group = sampleGroups.get(key);
            XYSeriesExtension series = group.getSeries();
            Set<Long> aboutToBeUpdatedKeys = group.getSamplesUnupdated().keySet();
            for (Long unupdatedSampleKey : aboutToBeUpdatedKeys) {
                long l;
                Sample sample = group.getSamplesUnupdated().get(unupdatedSampleKey);
                sample.calculateY(this.yCalculatorToUse);
                double y = sample.getY();
                if (!dottedMode && y != -1.0) {
                    ChartUtils.populateSeriesWithSamples(sample, series);
                }
                if (!hashesGettingUpdated.contains(l = sample.getFirstTs())) {
                    hashesGettingUpdated.add(l);
                }
                long[] minmaxPoints = this.getFilteredData().getMinmaxPoints();
                long earliest = minmaxPoints[0];
                long latest = minmaxPoints[1];
                ChartLogic.addSurroundingTimestampsAsUpdates(hashesGettingUpdated, l, earliest, latest, this.ranges, sample.getLength(), sampleTimestamps, group.getSamplesUnupdated());
            }
            group.getSamplesUnupdated().clear();
        }
    }
}

