/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.logic;

import com.loadcoder.load.chart.common.CommonSeries;
import com.loadcoder.load.chart.common.YCalculator;
import com.loadcoder.load.chart.logic.Chart;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.logic.ResultChartLogic;
import com.loadcoder.load.chart.menu.DataSetUserType;
import com.loadcoder.load.chart.menu.settings.DetailsSettings;
import com.loadcoder.result.Result;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class ResultChart
extends Chart {
    private static final boolean defaultPointsMode = false;
    final ResultChartLogic resultChartLogic;
    Result[] results;

    public ResultChart(CommonSeries[] commonSeries, Result ... results) {
        super(true, false, new ResultChartLogic(false, commonSeries, false, results));
        this.resultChartLogic = (ResultChartLogic)this.logic;
        long sampleLengthToUse = this.logic.getSampleLengthToUse();
        JMenu resultMenu = this.addResultMenu(sampleLengthToUse);
        JMenu settingsMenu = this.createSettingsMenu(this.logic);
        JMenu aboutMenu = this.createAboutMenu();
        this.chartFrame.setContentPane(this.resultChartLogic.panelForButtons);
        this.chartFrame.pack();
        this.chartFrame.setJMenuBar(this.resultChartLogic.getMenu());
        this.resultChartLogic.getMenu().add(resultMenu);
        this.resultChartLogic.getMenu().add(settingsMenu);
        this.resultChartLogic.getMenu().add(aboutMenu);
        this.chartFrame.setVisible(true);
        this.results = results;
    }

    public ResultChart(Result ... results) {
        this(CommonSeries.values(), results);
        this.results = results;
    }

    protected ChartLogic getLogic() {
        return this.logic;
    }

    private void toggleRemoveFilterCheckBox(DataSetUserType dataSetUserType, boolean selected) {
        this.resultChartLogic.setFilteredData(null);
        this.resultChartLogic.setDottedSeries(null);
        this.resultChartLogic.clearChart();
        this.resultChartLogic.getCommonSeriesMap().clear();
        this.logic.createCommons();
        this.logic.addAllCommonSeriesToTheChart();
        if (selected) {
            this.logic.getRemovalFiltersInUse().add(dataSetUserType);
        } else {
            this.logic.getRemovalFiltersInUse().remove(dataSetUserType);
        }
        this.resultChartLogic.createHashesAndUpdate(false);
    }

    private JMenu addResultMenu(long initialSampleLength) {
        JMenu resultMenu = new JMenu("Result");
        JMenu removalFiltersMenu = new JMenu("Removal filters");
        resultMenu.add(removalFiltersMenu);
        for (final DataSetUserType dataSetUserType : this.resultChartLogic.getRemovalFilters()) {
            JCheckBox checkbox = new JCheckBox(dataSetUserType.getName());
            checkbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean selected = e.getStateChange() == 1;
                    ResultChart.this.toggleRemoveFilterCheckBox(dataSetUserType, selected);
                }
            });
            removalFiltersMenu.add(checkbox);
        }
        JMenu sampling = new JMenu("Sampling");
        JMenu graphType = new JMenu("Graph type");
        double keepFactor = this.resultChartLogic.getCurrentKeepFactor();
        String pointsRadioButtonText = "Points";
        if (keepFactor != 1.0) {
            pointsRadioButtonText = String.format("Points (%s)", DetailsSettings.keepFactorToProcentString(keepFactor));
        }
        JRadioButtonMenuItem pointsRadioButton = new JRadioButtonMenuItem(pointsRadioButtonText, false);
        this.resultChartLogic.setPointsRadioButton(pointsRadioButton);
        JRadioButtonMenuItem samplesRadioButton = new JRadioButtonMenuItem("Samples", true);
        ButtonGroup graphTypeRadioButtonGroupForOneExclusiveSelection = new ButtonGroup();
        graphTypeRadioButtonGroupForOneExclusiveSelection.add(pointsRadioButton);
        graphTypeRadioButtonGroupForOneExclusiveSelection.add(samplesRadioButton);
        graphType.add(this.resultChartLogic.getPointsRadioButton());
        graphType.add(samplesRadioButton);
        resultMenu.add(graphType);
        this.resultChartLogic.getPointsRadioButton().addActionListener(a -> this.ajustDottedMode(true));
        samplesRadioButton.addActionListener(a -> this.ajustDottedMode(false));
        JMenu sampleMethod = new JMenu("Sample method");
        sampling.add(sampleMethod);
        resultMenu.add(sampling);
        ButtonGroup sampleMethodradioButtonGroupForOneExclusiveSelection = new ButtonGroup();
        List<YCalculator> yCalculators = this.logic.getyCalculators();
        for (YCalculator calc : yCalculators) {
            boolean selected = calc.equals(this.logic.getYCalculatorToUse());
            JRadioButtonMenuItem sampleMethodMenuIten = new JRadioButtonMenuItem(calc.getName(), selected);
            sampleMethodradioButtonGroupForOneExclusiveSelection.add(sampleMethodMenuIten);
            sampleMethod.add(sampleMethodMenuIten);
            sampleMethodMenuIten.addActionListener(a -> {
                this.resultChartLogic.clearChart();
                this.logic.addAllCommonSeriesToTheChart();
                this.logic.yCalculatorToUse = calc;
                this.resultChartLogic.createHashesAndUpdate(false);
            });
        }
        return resultMenu;
    }

    void ajustDottedMode(boolean dottedMode) {
        this.resultChartLogic.useDottedModeValue(dottedMode);
    }
}

