/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.menu.settings;

import com.loadcoder.load.chart.jfreechart.XYPlotExtension;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.menu.MouseClickedListener;
import com.loadcoder.load.chart.menu.settings.ChartSettingsActionsModel;
import com.loadcoder.load.chart.menu.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.data.xy.XYSeries;

public class ColorSettings
extends Settings {
    JColorChooser colorChooser;
    Component clickedButton;
    private XYSeriesExtension chosenSeries;
    private Map<XYSeriesExtension, Color> selections = new HashMap<XYSeriesExtension, Color>();
    private final ChartLogic chartLogic;
    private boolean colorChooserVisible = false;
    private Map<Component, XYSeriesExtension> selectionMap = new HashMap<Component, XYSeriesExtension>();
    private List<XYSeries> list;

    public ColorSettings(ChartLogic chartLogic, List<XYSeries> list) {
        super("Color");
        this.chartLogic = chartLogic;
        this.list = list;
    }

    public void setChosenSeries(XYSeriesExtension chosenSeries) {
        this.chosenSeries = chosenSeries;
    }

    public void setColorChooserVisible(boolean colorChooserVisible) {
        this.colorChooserVisible = colorChooserVisible;
    }

    public void changeSeriesColorSelection(Color chosenColor) {
        this.selections.put(this.chosenSeries, chosenColor);
    }

    public Color getSeriesColorSelection() {
        return this.selections.get((Object)this.chosenSeries);
    }

    public boolean isColorChooserVisible() {
        return this.colorChooserVisible;
    }

    public void addColorChooser(JComponent parent) {
        AbstractColorChooserPanel[] ccPanels;
        this.colorChooser = new JColorChooser(Color.GREEN);
        this.colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Color chosenColor = ColorSettings.this.colorChooser.getColor();
                ColorSettings.this.clickedButton.setBackground(chosenColor);
                ColorSettings.this.changeSeriesColorSelection(chosenColor);
            }
        });
        this.colorChooser.setBorder(BorderFactory.createTitledBorder("Choose new color"));
        for (AbstractColorChooserPanel ccPanel : ccPanels = this.colorChooser.getChooserPanels()) {
            ccPanel.getClass().getSimpleName();
            if (ccPanel.getDisplayName().equals("RGB")) continue;
            this.colorChooser.removeChooserPanel(ccPanel);
        }
        parent.add(this.colorChooser);
        this.colorChooser.setVisible(this.isColorChooserVisible());
    }

    public void addSeriesOptions(List<XYSeries> list, JPanel panelToAddOptionsTo) {
        GridBagConstraints c = new GridBagConstraints();
        int i = 0;
        while (i < list.size()) {
            XYSeriesExtension series = (XYSeriesExtension)list.get(i);
            JButton button = new JButton("");
            this.selectionMap.put(button, series);
            Color seriesColor = this.chartLogic.getExistingColors().get(series.getKey());
            button.setBackground(seriesColor);
            button.setPreferredSize(new Dimension(25, 25));
            button.addMouseListener(new MouseClickedListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ColorSettings.this.clickedButton = e.getComponent();
                    Color c = ColorSettings.this.clickedButton.getBackground();
                    ColorSettings.this.setChosenSeries((XYSeriesExtension)((Object)ColorSettings.this.selectionMap.get(ColorSettings.this.clickedButton)));
                    ColorSettings.this.setColorChooserVisible(true);
                    if (ColorSettings.this.isColorChooserVisible()) {
                        ColorSettings.this.colorChooser.setVisible(ColorSettings.this.isColorChooserVisible());
                    }
                    ColorSettings.this.colorChooser.setColor(c);
                }
            });
            JLabel label = new JLabel("" + series.getKey());
            c.gridx = 0;
            c.gridy = i;
            panelToAddOptionsTo.add((Component)button, c);
            c.gridx = 1;
            c.gridy = i++;
            panelToAddOptionsTo.add((Component)label, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(ChartSettingsActionsModel chartSettingsActionsModel) {
        XYPlotExtension plot;
        XYPlotExtension xYPlotExtension = plot = this.chartLogic.getPlot();
        synchronized (xYPlotExtension) {
            Iterator<Map.Entry<XYSeriesExtension, Color>> i = this.selections.entrySet().iterator();
            while (i.hasNext()) {
                chartSettingsActionsModel.setRender(true);
                Map.Entry<XYSeriesExtension, Color> entry = i.next();
                Color newColor = entry.getValue();
                XYSeriesExtension series = entry.getKey();
                Color oldColor = this.chartLogic.getExistingColors().get(series.getKey());
                series.getLegend().setFillPaint((Paint)newColor);
                series.getLegend().setOutlinePaint((Paint)newColor);
                Map<String, Color> existingColors = this.chartLogic.getExistingColors();
                existingColors.put(series.getKey(), newColor);
            }
        }
    }

    @Override
    JPanel getWindow() {
        JPanel colorChooserPanel = new JPanel(new BorderLayout());
        JPanel jp1 = new JPanel(new GridBagLayout());
        colorChooserPanel.add((Component)jp1, "West");
        this.addSeriesOptions(this.list, jp1);
        this.addColorChooser(colorChooserPanel);
        return colorChooserPanel;
    }
}

