/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.menu.settings;

import com.loadcoder.load.chart.logic.ResultChartLogic;
import com.loadcoder.load.chart.menu.DoubleSteppingSlider;
import com.loadcoder.load.chart.menu.settings.ChartSettingsActionsModel;
import com.loadcoder.load.chart.menu.settings.Settings;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DetailsSettings
extends Settings {
    private double keepFactorSelection = -1.0;
    JRadioButtonMenuItem points;
    private final ResultChartLogic chartLogic;
    Dictionary<Integer, Component> labelTable = new Hashtable<Integer, Component>();
    private static final Double[] doubles = DetailsSettings.generateKeepFactorValues();

    public DetailsSettings(ResultChartLogic chartLogic) {
        super("Details");
        this.chartLogic = chartLogic;
    }

    public static String keepFactorToProcentString(double value) {
        long multiRounding = Math.round(value * 10000.0);
        double rounded = (double)multiRounding / 100.0;
        if (rounded >= 1.0) {
            return "" + (long)rounded + "%";
        }
        return "" + rounded + "%";
    }

    protected static Double[] generateKeepFactorValues() {
        ArrayList<Double> values = new ArrayList<Double>();
        for (double i = 1.0E-4; i < 1.0; i *= 10.0) {
            double roundMultiplicator = 1.0 / i;
            for (long j = 1L; j < 10L; ++j) {
                long l = Math.round((double)j);
                double rounded = (double)l / roundMultiplicator;
                values.add(rounded);
            }
        }
        values.add(1.0);
        Double[] doubleArray = values.toArray(new Double[values.size()]);
        return doubleArray;
    }

    @Override
    public void apply(ChartSettingsActionsModel chartSettingsActionsModel) {
        if (this.getKeepFactorSelection() != -1.0) {
            ResultChartLogic resultChartLogic = this.chartLogic;
            resultChartLogic.setKeepFactorChosen(this.keepFactorSelection);
            String keepFactorAsProcentString = DetailsSettings.keepFactorToProcentString(this.keepFactorSelection);
            resultChartLogic.getPointsRadioButton().setText(String.format("Points (%s)", keepFactorAsProcentString));
            chartSettingsActionsModel.setRecreatePoints(true);
        }
        if (this.chartLogic.getNewSampleLengthSelection() != -1L) {
            this.chartLogic.chartSliderAjustment(this.chartLogic.getNewSampleLengthSelection());
        }
    }

    public double getKeepFactorSelection() {
        return this.keepFactorSelection;
    }

    public void setKeepFactorSelection(double keepFactorSelection) {
        this.keepFactorSelection = keepFactorSelection;
    }

    @Override
    JPanel getWindow() {
        this.labelTable.put(0, new JLabel("" + doubles[0] * 100.0 + "%"));
        this.labelTable.put(doubles.length - 1, new JLabel("100%"));
        JPanel detailsLeftArea = new JPanel(new FlowLayout(0));
        GridBagConstraints c = new GridBagConstraints();
        JPanel jp2 = new JPanel(new GridBagLayout());
        final JTextArea textField = new JTextArea();
        int startIndex = 0;
        if (this.chartLogic instanceof ResultChartLogic) {
            ResultChartLogic resultChartLogic = this.chartLogic;
            double keepFactor = resultChartLogic.getCurrentKeepFactor();
            startIndex = DoubleSteppingSlider.getIndexOf(doubles, keepFactor);
            textField.setText(DetailsSettings.keepFactorToProcentString(keepFactor));
        }
        DoubleSteppingSlider pointsKeepFactorSlider = new DoubleSteppingSlider(doubles, startIndex);
        pointsKeepFactorSlider.setLabelTable(this.labelTable);
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                DoubleSteppingSlider source = (DoubleSteppingSlider)event.getSource();
                int index = source.getValue();
                double value = source.getValues()[index];
                String valueAsProcent = DetailsSettings.keepFactorToProcentString(value);
                textField.setText(valueAsProcent);
                DetailsSettings.this.setKeepFactorSelection(value);
            }
        };
        pointsKeepFactorSlider.addChangeListener(listener);
        JLabel keepFactorSliderDescription = new JLabel("Drag the slider in order to change how many percent of the points that is going to be rendered");
        Font f = keepFactorSliderDescription.getFont();
        keepFactorSliderDescription.setFont(f.deriveFont(f.getStyle() ^ 1));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        jp2.add((Component)keepFactorSliderDescription, c);
        c.gridx = 0;
        c.gridy = 1;
        jp2.add((Component)pointsKeepFactorSlider, c);
        c.gridx = 1;
        c.gridy = 1;
        jp2.add((Component)textField, c);
        JLabel space = new JLabel(" ");
        c.gridx = 0;
        c.gridy = 2;
        jp2.add((Component)space, c);
        JLabel keepFactorSliderDescription2 = new JLabel("Drag the slider to adjust the sample length in seconds");
        f = keepFactorSliderDescription2.getFont();
        keepFactorSliderDescription2.setFont(f.deriveFont(f.getStyle() ^ 1));
        c.gridx = 0;
        c.gridy = 3;
        jp2.add((Component)keepFactorSliderDescription2, c);
        c.gridx = 0;
        c.gridy = 4;
        jp2.add((Component)this.chartLogic.getSteppingSlider(), c);
        keepFactorSliderDescription.setBackground(Color.LIGHT_GRAY);
        keepFactorSliderDescription.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        detailsLeftArea.add(jp2);
        return detailsLeftArea;
    }
}

