/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.menu.settings;

import com.loadcoder.load.chart.jfreechart.ChartFrame;
import com.loadcoder.load.chart.jfreechart.XYSeriesCollectionExtention;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.logic.ChartLogic;
import com.loadcoder.load.chart.logic.ResultChartLogic;
import com.loadcoder.load.chart.menu.MouseClickedListener;
import com.loadcoder.load.chart.menu.settings.ChartSettingsActionsModel;
import com.loadcoder.load.chart.menu.settings.ColorSettings;
import com.loadcoder.load.chart.menu.settings.DetailsSettings;
import com.loadcoder.load.chart.menu.settings.Settings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SettingsWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    List<Settings> settings = new ArrayList<Settings>();
    ChartLogic chartLogic;
    JPanel bottomButtons = new JPanel();

    public SettingsWindow(ChartFrame parent, String title, ChartLogic chartLogic) {
        super((Frame)((Object)parent), title, true);
        this.setPreferredSize(new Dimension(1000, 500));
        this.chartLogic = chartLogic;
        this.settings.add(new ColorSettings(chartLogic, ((XYSeriesCollectionExtention)chartLogic.getPlot().getDataset()).getSeries()));
        if (chartLogic instanceof ResultChartLogic) {
            this.settings.add(new DetailsSettings((ResultChartLogic)chartLogic));
        }
        JPanel base = new JPanel(new BorderLayout());
        this.getContentPane().add(base);
        JTabbedPane jtp = new JTabbedPane(2);
        base.add(jtp);
        JPanel bottomButtonsBase = new JPanel();
        bottomButtonsBase.add((Component)this.bottomButtons, "East");
        base.add((Component)bottomButtonsBase, "South");
        this.setTitle("Settings");
        for (Settings setting : this.settings) {
            JPanel area = new JPanel(new FlowLayout(0));
            area.add(setting.getWindow());
            jtp.addTab(setting.getName(), area);
        }
        this.addBottomButtons(this.bottomButtons);
        this.pack();
        this.setVisible(true);
    }

    protected void handleChartSettingsActionsModel(ChartSettingsActionsModel model) {
        if (model.isRecreatePoints()) {
            ResultChartLogic resultChartLogic = (ResultChartLogic)this.chartLogic;
            resultChartLogic.recreateDottedSeries();
        } else if (model.isRender()) {
            this.chartLogic.forceRerender();
        }
    }

    protected void addBottomButtons(JPanel parent) {
        JButton applyButton = new JButton("Apply");
        applyButton.addMouseListener(new MouseClickedListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChartSettingsActionsModel model = new ChartSettingsActionsModel();
                SettingsWindow.this.settings.stream().forEach(a -> a.apply(model));
                SettingsWindow.this.handleChartSettingsActionsModel(model);
            }
        });
        JButton okButton = new JButton("Ok");
        okButton.addMouseListener(new MouseClickedListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChartSettingsActionsModel model = new ChartSettingsActionsModel();
                SettingsWindow.this.settings.stream().forEach(a -> a.apply(model));
                SettingsWindow.this.handleChartSettingsActionsModel(model);
                SettingsWindow.this.dispose();
            }
        });
        JButton closeButton = new JButton("Close");
        closeButton.addMouseListener(new MouseClickedListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SettingsWindow.this.dispose();
            }
        });
        parent.add(okButton);
        parent.add(applyButton);
        parent.add(closeButton);
    }

    public class ColorSelectionSetting {
        public Component button;
        public XYSeriesExtension series;

        public ColorSelectionSetting(Component button, XYSeriesExtension series) {
            this.button = button;
            this.series = series;
        }
    }
}

