/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.utilities;

import com.loadcoder.load.chart.data.Point;
import com.loadcoder.load.chart.jfreechart.XYSeriesExtension;
import com.loadcoder.load.chart.sampling.Sample;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ChartUtils {
    public static void populateSeriesWithSamples(Sample sample, XYSeriesExtension series) {
        if (sample.getFirst() == null) {
            sample.initDataItems();
            series.add(sample.getFirst(), false);
        } else {
            sample.updateDataItems();
        }
    }

    public static void populateSeriesWithPoints(List<Point> points, XYSeriesExtension series, double keepFactor) {
        HashMap<Long, ArrayList<Point>> responseTimePointsMap = new HashMap<Long, ArrayList<Point>>();
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            ArrayList<Point> pointsForResponseTime = (ArrayList<Point>)responseTimePointsMap.get(point.getY());
            if (pointsForResponseTime == null) {
                pointsForResponseTime = new ArrayList<Point>();
                responseTimePointsMap.put(point.getY(), pointsForResponseTime);
            }
            pointsForResponseTime.add(point);
        }
        List responeTimeGroup = responseTimePointsMap.entrySet().stream().map(a -> (Long)a.getKey()).collect(Collectors.toList());
        responeTimeGroup.sort((a, b) -> {
            int diff = ((List)responseTimePointsMap.get(a)).size() - ((List)responseTimePointsMap.get(b)).size();
            return diff;
        });
        int added = 0;
        int processed = 0;
        for (Long rts : responeTimeGroup) {
            List p = (List)responseTimePointsMap.get(rts);
            int pSize = p.size();
            for (int i = 0; i < pSize; ++i) {
                ++processed;
                Point point = (Point)p.get(i);
                if (!point.isEnabled()) continue;
                if (pSize == 1) {
                    long x = point.getX();
                    long y = point.getY();
                    series.add(x, y, false);
                    ++added;
                    continue;
                }
                double factorIfAdded = (double)(added + 1) / (double)processed;
                double factorIfNotAdded = (double)added / (double)processed;
                double distanceIfAdded = keepFactor - factorIfAdded;
                double distanceIfNotAdded = keepFactor - factorIfNotAdded;
                if (distanceIfAdded < 0.0) {
                    distanceIfAdded *= -1.0;
                }
                if (distanceIfNotAdded < 0.0) {
                    distanceIfNotAdded *= -1.0;
                }
                if (!(distanceIfAdded < distanceIfNotAdded)) continue;
                long x = point.getX();
                long y = point.getY();
                series.add(x, y, false);
                ++added;
            }
        }
    }

    public static double calculateKeepFactor(int totalAmountOfPoints, int targetItemsInChart) {
        double keepFactor;
        if (totalAmountOfPoints <= targetItemsInChart) {
            return 1.0;
        }
        int multiplier = 1;
        for (keepFactor = (double)targetItemsInChart / (double)totalAmountOfPoints; keepFactor < 1.0; keepFactor *= 10.0) {
            multiplier *= 10;
        }
        long roundedMultiplied = Math.round(keepFactor);
        double rounded = (double)roundedMultiplied / (double)multiplier;
        if (rounded < 1.0E-4) {
            rounded = 1.0E-4;
        }
        return rounded;
    }
}

