/*
 * Decompiled with CFR 0.152.
 */
package com.loadcoder.load.chart.utilities;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ColorUtils {
    public static final List<Color> extremeColors = Arrays.asList(Color.BLACK, Color.RED, Color.GREEN, Color.BLUE, new Color(255, 255, 0), new Color(255, 0, 255), new Color(0, 255, 255), Color.WHITE);
    public static final List<Color> defaultBlacklistColors = Arrays.asList(Color.YELLOW, Color.WHITE);

    public static Color getNewContrastfulColor(Set<Color> colors, List<Color> blacklistedColors) {
        ArrayList<Color> colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible = new ArrayList<Color>();
        colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible.addAll(colors);
        colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible.addAll(blacklistedColors);
        List<Color> newColors = ColorUtils.getNewPotentialColors(colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible);
        Color newColor = ColorUtils.findColorWithLongestDistanceToClosestNeighbour(newColors, colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible);
        return newColor;
    }

    protected static Color findColorWithLongestDistanceToClosestNeighbour(List<Color> newColors, List<Color> existingColors) {
        Color result = null;
        double distanceOfTheClosestNeighbourOfAllColors = 0.0;
        for (int i = 0; i < newColors.size(); ++i) {
            Color potentialColor = newColors.get(i);
            double distanceToTheClosestNeighbourForThisColor = 500.0;
            for (int j = 0; j < existingColors.size(); ++j) {
                Color toCompareWith = existingColors.get(j);
                double distance = ColorUtils.calculateDistance(potentialColor, toCompareWith);
                if (!(distance < distanceToTheClosestNeighbourForThisColor)) continue;
                distanceToTheClosestNeighbourForThisColor = distance;
            }
            if (!(distanceToTheClosestNeighbourForThisColor > distanceOfTheClosestNeighbourOfAllColors)) continue;
            distanceOfTheClosestNeighbourOfAllColors = distanceToTheClosestNeighbourForThisColor;
            result = potentialColor;
        }
        return result;
    }

    public static List<Color> getExtremeColorsAsPotentials(List<Color> alreadyExistingColors) {
        ArrayList<Color> result = new ArrayList<Color>();
        for (Color extremeColor : extremeColors) {
            if (alreadyExistingColors.contains(extremeColor)) continue;
            result.add(extremeColor);
        }
        return result;
    }

    protected static List<Color> getNewPotentialColors(List<Color> colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible) {
        List<Color> result = ColorUtils.getExtremeColorsAsPotentials(colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible);
        for (int i = 0; i < colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible.size(); ++i) {
            Color toBeCompared = colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible.get(i);
            for (int j = i + 1; j < colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible.size(); ++j) {
                Color toMixWith = colorsThatShouldBeAsFarAwayAsTheNewColorAsPossible.get(j);
                Color mixed = ColorUtils.mixColors(toBeCompared, toMixWith);
                result.add(mixed);
            }
        }
        return result;
    }

    public static Color mixColors(Color c1, Color c2) {
        int r = (c1.getRed() + c2.getRed()) / 2;
        int g = (c1.getGreen() + c2.getGreen()) / 2;
        int b = (c1.getBlue() + c2.getBlue()) / 2;
        Color c = new Color(r, g, b);
        return c;
    }

    public static double calculateDistance(Color c1, Color c2) {
        int r1 = c1.getRed();
        int r2 = c2.getRed();
        int g1 = c1.getGreen();
        int g2 = c2.getGreen();
        int b1 = c1.getBlue();
        int b2 = c2.getBlue();
        double distance = Math.sqrt(Math.pow(r1 - r2, 2.0) + Math.pow(g1 - g2, 2.0) + Math.pow(b1 - b2, 2.0));
        return distance;
    }
}

