/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.object;

import com.metaobjects.generator.GeneratorException;
import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.generator.direct.GenerationContext;
import com.metaobjects.generator.direct.MultiFileDirectGeneratorBase;
import com.metaobjects.generator.direct.object.BaseObjectCodeWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.object.MetaObject;
import java.io.File;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseObjectCodeGenerator
extends MultiFileDirectGeneratorBase<MetaObject> {
    public static final String ARG_TYPE = "type";
    public static final String ARG_PKGPREFIX = "pkgPrefix";
    public static final String ARG_PKGSUFFIX = "pkgSuffix";
    public static final String ARG_NAMEPREFIX = "namePrefix";
    public static final String ARG_NAMESUFFIX = "nameSuffix";
    public static final String ARG_OPTARRAYS = "optArrays";
    public static final String ARG_OPTKEYS = "optKeys";
    public static final String ARG_DEBUG = "debug";
    protected static final String ERROR_FINALOUTPUTDIR_REQUIRED = " argument is required when a " + ARG_OUTPUTFILENAME + " is specified";
    protected static final String ERROR_TYPE_REQUIRED = " argument is required";
    protected static final String ERROR_TYPE_INVALID = " argument has invalid value";
    protected Map<MetaObject, String> objectNameMap = new LinkedHashMap<MetaObject, String>();
    protected GenerationContext globalContext = new GenerationContext(null);
    protected MetaDataLoader currentLoader = null;

    protected abstract String[] getSupportedTypes();

    protected abstract String getDefaultType();

    protected abstract BaseObjectCodeWriter createWriter(MetaDataLoader var1, MetaObject var2, PrintWriter var3, GenerationContext var4);

    protected abstract String getFileExtension();

    public BaseObjectCodeGenerator withGlobalContext(GenerationContext context) {
        this.globalContext = context;
        return this;
    }

    @Override
    protected void parseArgs() {
        if (this.hasArg(ARG_OUTPUTFILENAME) && !this.hasArg(ARG_FINALOUTPUTDIR)) {
            throw new GeneratorException(ARG_FINALOUTPUTDIR + ERROR_FINALOUTPUTDIR_REQUIRED);
        }
        if (!this.hasArg(ARG_TYPE)) {
            throw new GeneratorException("type argument is required");
        }
        String type = this.getArg(ARG_TYPE);
        CharSequence[] supportedTypes = this.getSupportedTypes();
        boolean typeSupported = false;
        for (String string : supportedTypes) {
            if (!string.equals(type)) continue;
            typeSupported = true;
            break;
        }
        if (!typeSupported) {
            throw new GeneratorException("type argument has invalid value. Supported: " + String.join((CharSequence)", ", supportedTypes));
        }
        super.parseArgs();
        this.globalContext = null;
        if (log.isDebugEnabled()) {
            log.debug("Enhanced ParseArgs: " + this.toString());
        }
    }

    public String getType() {
        return this.getArg(ARG_TYPE, this.getDefaultType());
    }

    public String getPkgPrefix() {
        return this.getArg(ARG_PKGPREFIX, "");
    }

    public String getPkgSuffix() {
        return this.getArg(ARG_PKGSUFFIX, "");
    }

    public String getNamePrefix() {
        return this.getArg(ARG_NAMEPREFIX, "");
    }

    public String getNameSuffix() {
        return this.getArg(ARG_NAMESUFFIX, "");
    }

    public boolean addArrayMethods() {
        return Boolean.valueOf(this.getArg(ARG_OPTARRAYS, "false"));
    }

    public boolean addKeyMethods() {
        return Boolean.valueOf(this.getArg(ARG_OPTKEYS, "false"));
    }

    @Override
    protected Class<MetaObject> getFilterClass() {
        return MetaObject.class;
    }

    @Override
    protected GeneratorIOWriter getSingleWriter(MetaDataLoader loader, MetaObject md, PrintWriter pw) throws GeneratorIOException {
        if (this.currentLoader == null) {
            this.currentLoader = loader;
            this.globalContext = new GenerationContext(loader);
            this.configureGlobalContext();
        }
        GenerationContext fileContext = new GenerationContext(loader);
        this.copyContextSettings(this.globalContext, fileContext);
        return this.createWriter(loader, md, pw, fileContext);
    }

    protected void configureGlobalContext() {
        this.globalContext.setProperty("generator.type", this.getType()).setProperty("package.prefix", this.getPkgPrefix()).setProperty("package.suffix", this.getPkgSuffix()).setProperty("name.prefix", this.getNamePrefix()).setProperty("name.suffix", this.getNameSuffix()).setProperty("generate.arrayMethods", this.addArrayMethods()).setProperty("generate.keyMethods", this.addKeyMethods()).setProperty(ARG_DEBUG, this.hasArg(ARG_DEBUG));
    }

    protected void copyContextSettings(GenerationContext source, GenerationContext target) {
        for (String key : List.of("generator.type", "package.prefix", "package.suffix", "name.prefix", "name.suffix", "generate.arrayMethods", "generate.keyMethods", ARG_DEBUG)) {
            if (source.getProperty(key, null) == null) continue;
            target.setProperty(key, source.getProperty(key, null));
        }
    }

    @Override
    protected void writeSingleFile(MetaObject mo, GeneratorIOWriter<?> writer) throws GeneratorIOException {
        log.info("Writing " + this.getLanguageName() + " Code [" + this.getType() + "] to file: " + writer.getFilename());
        String className = ((BaseObjectCodeWriter)writer).writeObject(mo);
        this.objectNameMap.put(mo, className);
    }

    protected abstract String getLanguageName();

    @Override
    protected String getSingleOutputFilePath(MetaObject md) {
        Object path = md.getPackage().replaceAll("::", ".");
        if (this.isNotBlank(this.getPkgPrefix())) {
            String pre = this.getPkgPrefix();
            path = pre.endsWith(".") ? pre + (String)path : pre + "." + (String)path;
        }
        if (this.isNotBlank(this.getPkgSuffix())) {
            String suf = this.getPkgSuffix();
            path = suf.startsWith(".") ? (String)path + suf : (String)path + "." + suf;
        }
        path = ((String)path).replace('.', this.getPathSeparator());
        return path;
    }

    protected char getPathSeparator() {
        return File.separatorChar;
    }

    @Override
    protected String getSingleOutputFilename(MetaObject md) {
        Object name = md.getShortName();
        if (this.isNotBlank(this.getNamePrefix())) {
            name = this.getNamePrefix() + "-" + (String)name;
        }
        if (this.isNotBlank(this.getNameSuffix())) {
            name = (String)name + "-" + this.getNameSuffix();
        }
        name = ((String)name).replaceAll("--", "-");
        name = this.convertToLanguageNaming((String)name) + this.getFileExtension();
        return name;
    }

    protected abstract String convertToLanguageNaming(String var1);

    protected boolean isNotBlank(String str) {
        return str != null && !str.trim().isEmpty();
    }

    @Override
    public String toString() {
        return super.toString() + ",context=" + (this.globalContext != null ? "initialized" : "null");
    }
}

