package com.metaobjects.generator.direct.object.javacode;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorIOWriter;
import com.metaobjects.generator.direct.object.BaseObjectCodeGenerator;
import com.metaobjects.generator.direct.object.BaseObjectCodeWriter;
import com.metaobjects.generator.direct.GenerationContext;
import com.metaobjects.generator.util.GeneratorUtil;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.object.MetaObject;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;

/**
 * Java-specific implementation of Object Code Generator
 */
public class JavaCodeGenerator extends BaseObjectCodeGenerator {

    public final static String TYPE_INTERFACE  = "interface";
    public final static String TYPE_CLASS      = "class";

    @Override
    protected String[] getSupportedTypes() {
        return new String[]{TYPE_INTERFACE, TYPE_CLASS};
    }

    @Override
    protected String getDefaultType() {
        return TYPE_INTERFACE;
    }

    @Override
    protected BaseObjectCodeWriter createWriter(MetaDataLoader loader, MetaObject md, PrintWriter pw, GenerationContext context) {
        return new JavaCodeWriter(loader, pw, context)
                .forType(getType())
                .withPkgPrefix(getPkgPrefix())
                .withPkgSuffix(getPkgSuffix())
                .withNamePrefix(getNamePrefix())
                .withNameSuffix(getNameSuffix())
                .addArrayMethods(addArrayMethods())
                .addKeyMethods(addKeyMethods())
                .withIndentor("    ");
    }

    @Override
    protected String getFileExtension() {
        return ".java";
    }

    @Override
    protected String getLanguageName() {
        return "Java";
    }

    @Override
    protected String convertToLanguageNaming(String name) {
        // Java uses PascalCase for class names
        return GeneratorUtil.toCamelCase(name, true);
    }

    @Override
    protected GeneratorIOWriter getFinalWriter(MetaDataLoader loader, OutputStream out) throws GeneratorIOException {
        return null;
        //return new JavaCodeOverlayXMLWriter(loader, out)
        //        .forObjects(objectNameMap);
    }

    @Override
    protected void writeFinalFile(Collection<MetaObject> metadata, GeneratorIOWriter<?> writer) throws GeneratorIOException {
        // No final file needed for Java generation - each MetaObject generates its own file
        // This method is required by the abstract base class but intentionally left empty
    }
}