/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator;

import com.metaobjects.generator.direct.metadata.ai.MetaDataAIDocumentationWriter;
import com.metaobjects.generator.direct.metadata.file.json.MetaDataFileSchemaWriter;
import com.metaobjects.generator.direct.metadata.file.xsd.MetaDataFileXSDWriter;
import com.metaobjects.registry.MetaDataRegistry;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaReviewTest {
    private static final Logger log = LoggerFactory.getLogger(SchemaReviewTest.class);

    @Before
    public void setUp() {
        try {
            Class.forName("com.metaobjects.field.StringField");
            Class.forName("com.metaobjects.field.IntegerField");
            Class.forName("com.metaobjects.field.LongField");
            Class.forName("com.metaobjects.field.DoubleField");
            Class.forName("com.metaobjects.field.DateField");
            Class.forName("com.metaobjects.field.TimestampField");
            Class.forName("com.metaobjects.object.MetaObject");
            Class.forName("com.metaobjects.object.pojo.PojoMetaObject");
            Class.forName("com.metaobjects.object.proxy.ProxyMetaObject");
            Class.forName("com.metaobjects.attr.StringAttribute");
            Class.forName("com.metaobjects.attr.IntAttribute");
            Class.forName("com.metaobjects.attr.BooleanAttribute");
        }
        catch (ClassNotFoundException e) {
            log.warn("Some core types not available for testing: {}", (Object)e.getMessage());
        }
        MetaDataRegistry registry = MetaDataRegistry.getInstance();
        log.info("Registry initialized with {} registered types", (Object)registry.getRegisteredTypes().size());
        log.info("Constraint count: {}", (Object)registry.getAllValidationConstraints().size());
        log.info("Registered types: {}", (Object)registry.getRegisteredTypeNames());
    }

    @Test
    public void generateAllSchemasForReview() throws Exception {
        MetaDataFileXSDWriter xsdWriter;
        MetaDataFileSchemaWriter jsonWriter;
        MetaDataAIDocumentationWriter aiWriter;
        log.info("=== GENERATING ALL SCHEMAS FOR COMPREHENSIVE REVIEW ===");
        log.info("Generating AI documentation...");
        try (FileOutputStream aiOut = new FileOutputStream("target/ai-documentation.json");){
            aiWriter = new MetaDataAIDocumentationWriter(null, (OutputStream)aiOut);
            aiWriter.withInheritance(true).withExtensionGuidance(true).withCrossLanguageInfo(true);
            aiWriter.writeJson();
            aiWriter.close();
            log.info("\u2705 Generated AI documentation: target/ai-documentation.json");
        }
        aiOut = new FileOutputStream("target/working-ai-documentation.json");
        try {
            aiWriter = new MetaDataAIDocumentationWriter(null, (OutputStream)aiOut);
            aiWriter.withInheritance(true).withExtensionGuidance(true).withCrossLanguageInfo(true);
            aiWriter.writeJson();
            aiWriter.close();
            log.info("\u2705 Generated working AI documentation: target/working-ai-documentation.json");
        }
        finally {
            aiOut.close();
        }
        log.info("Generating JSON schema...");
        try (FileOutputStream jsonOut = new FileOutputStream("target/metadata-schema.json");){
            jsonWriter = new MetaDataFileSchemaWriter(null, (OutputStream)jsonOut);
            jsonWriter.writeJson();
            jsonWriter.close();
            log.info("\u2705 Generated JSON schema: target/metadata-schema.json");
        }
        jsonOut = new FileOutputStream("target/working-metadata-schema.json");
        try {
            jsonWriter = new MetaDataFileSchemaWriter(null, (OutputStream)jsonOut);
            jsonWriter.writeJson();
            jsonWriter.close();
            log.info("\u2705 Generated working JSON schema: target/working-metadata-schema.json");
        }
        finally {
            jsonOut.close();
        }
        log.info("Generating XSD schema...");
        try (FileOutputStream xsdOut = new FileOutputStream("target/metadata-schema.xsd");){
            xsdWriter = new MetaDataFileXSDWriter(null, (OutputStream)xsdOut);
            xsdWriter.writeXML();
            xsdWriter.close();
            log.info("\u2705 Generated XSD schema: target/metadata-schema.xsd");
        }
        xsdOut = new FileOutputStream("target/working-metadata-schema.xsd");
        try {
            xsdWriter = new MetaDataFileXSDWriter(null, (OutputStream)xsdOut);
            xsdWriter.writeXML();
            xsdWriter.close();
            log.info("\u2705 Generated working XSD schema: target/working-metadata-schema.xsd");
        }
        finally {
            xsdOut.close();
        }
        log.info("=== ALL SCHEMAS GENERATED SUCCESSFULLY ===");
        log.info("Review files in codegen-base/target/:");
        log.info("- ai-documentation.json (AI-optimized metadata documentation)");
        log.info("- metadata-schema.json (JSON Schema for metadata validation)");
        log.info("- metadata-schema.xsd (XSD Schema for XML metadata validation)");
    }
}

