/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.html;

import com.metaobjects.generator.GeneratorIOException;
import com.metaobjects.generator.GeneratorTestBase;
import com.metaobjects.generator.direct.metadata.html.MetaDataHtmlDocumentationGenerator;
import com.metaobjects.generator.direct.metadata.html.MetaDataHtmlDocumentationWriter;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.loader.simple.SimpleLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.Arrays;
import org.junit.Test;

public class HtmlDocumentationGeneratorExample
extends GeneratorTestBase {
    @Test
    public void demonstrateGeneratorConfiguration() {
        MetaDataHtmlDocumentationGenerator generator = new MetaDataHtmlDocumentationGenerator();
        generator.setTitle("Custom Framework Documentation");
        generator.setVersion("1.0.0");
        generator.setIncludeInheritance(true);
        generator.setIncludeExamples(false);
        generator.setIncludeExtensionGuide(true);
        System.out.println("\n" + generator.getConfigurationSummary());
        System.out.println("\nGenerator toString: " + generator.toString());
    }

    public void mavenPluginConfigurationExample() {
    }

    @Test
    public void generateHtmlDocumentationToTargetFolder() throws GeneratorIOException, IOException, URISyntaxException {
        System.out.println("\n=== Generating HTML Documentation to target/html folder ===");
        File targetDir = new File("target/html");
        if (!targetDir.exists()) {
            boolean created = targetDir.mkdirs();
            System.out.println("Created target/html directory: " + created);
        }
        URI testMetadataUri = ((Object)((Object)this)).getClass().getClassLoader().getResource("template-test-metadata.json").toURI();
        SimpleLoader loader = this.initLoader(Arrays.asList(testMetadataUri));
        System.out.println("Loaded metadata from: " + String.valueOf(testMetadataUri));
        System.out.println("Loader has " + loader.getChildren().size() + " root children");
        File htmlFile = new File(targetDir, "metaobjects-documentation.html");
        try (FileOutputStream fos = new FileOutputStream(htmlFile);){
            MetaDataHtmlDocumentationWriter writer = new MetaDataHtmlDocumentationWriter((MetaDataLoader)loader, (OutputStream)fos).withTitle("MetaObjects Test Documentation").withVersion("6.2.0-TEST").withInheritance(true).withExamples(true).withExtensionGuide(true);
            writer.writeHtml();
            writer.close();
        }
        assert (htmlFile.exists()) : "HTML documentation file should exist";
        assert (htmlFile.length() > 0L) : "HTML documentation file should have content";
        System.out.println("Generated HTML documentation:");
        System.out.println("  File: " + htmlFile.getAbsolutePath());
        System.out.println("  Size: " + htmlFile.length() + " bytes");
        String content = Files.readString(htmlFile.toPath());
        assert (content.contains("<!DOCTYPE html>")) : "Should contain DOCTYPE declaration";
        assert (content.contains("MetaObjects Test Documentation")) : "Should contain custom title";
        assert (content.contains("Framework Overview")) : "Should contain overview section";
        assert (content.contains("Type Registry Statistics")) : "Should contain statistics section";
        assert (content.contains("Extension & Plugin Development Guide")) : "Should contain extension guide";
        String[] lines = content.split("\n");
        System.out.println("  Lines: " + lines.length);
        System.out.println("  Sections: " + this.countOccurrences(content, "<section"));
        System.out.println("  Type cards: " + this.countOccurrences(content, "type-card"));
        System.out.println("\nFirst 5 lines of generated HTML:");
        for (int i = 0; i < Math.min(5, lines.length); ++i) {
            System.out.println("  " + (i + 1) + ": " + lines[i]);
        }
        System.out.println("\n\u2705 Successfully generated HTML documentation to: " + htmlFile.getAbsolutePath());
    }

    @Test
    public void generateMinimalHtmlDocumentationToByteArray() throws GeneratorIOException, IOException {
        System.out.println("\n=== Testing Minimal HTML Generation ===");
        SimpleLoader loader = HtmlDocumentationGeneratorExample.getSharedLoader();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MetaDataHtmlDocumentationWriter writer = new MetaDataHtmlDocumentationWriter((MetaDataLoader)loader, (OutputStream)outputStream).withTitle("Registry-Only Documentation").withVersion("6.2.0-MINIMAL").withInheritance(true).withExamples(false).withExtensionGuide(false);
        writer.writeHtml();
        writer.close();
        String generatedHtml = outputStream.toString();
        assert (generatedHtml.contains("<!DOCTYPE html>"));
        assert (generatedHtml.contains("Registry-Only Documentation"));
        assert (generatedHtml.contains("Framework Overview"));
        assert (generatedHtml.contains("Type Registry Statistics"));
        System.out.println("Generated minimal HTML: " + generatedHtml.length() + " characters");
        System.out.println("Contains " + this.countOccurrences(generatedHtml, "<section") + " sections");
        System.out.println("\u2705 Minimal HTML generation successful");
    }

    private int countOccurrences(String text, String substring) {
        int count = 0;
        int index = 0;
        while ((index = text.indexOf(substring, index)) != -1) {
            ++count;
            index += substring.length();
        }
        return count;
    }
}

