/*
 * Decompiled with CFR 0.152.
 */
package com.metaobjects.generator.direct.metadata.ai;

import com.metaobjects.generator.direct.metadata.ai.MetaDataAIDocumentationWriter;
import com.metaobjects.generator.direct.metadata.json.JsonDirectWriter;
import com.metaobjects.generator.direct.metadata.json.SingleJsonDirectGeneratorBase;
import com.metaobjects.loader.MetaDataLoader;
import com.metaobjects.registry.MetaDataRegistry;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataAIDocumentationGenerator
extends SingleJsonDirectGeneratorBase {
    private static final Logger log = LoggerFactory.getLogger(MetaDataAIDocumentationGenerator.class);
    private String version = "6.1.0";
    private boolean includeInheritance = true;
    private boolean includeImplementationDetails = true;
    private boolean includeExtensionGuidance = true;
    private boolean includeCrossLanguageInfo = false;
    public static final String AI_VERSION = "aiVersion";
    public static final String AI_DESCRIPTION = "aiDescription";
    public static final String AI_BUSINESS_RULE = "aiBusinessRule";
    public static final String AI_USAGE_CONTEXT = "aiUsageContext";
    public static final String AI_VALIDATION_RULES = "aiValidationRules";
    public static final String AI_EXAMPLES = "aiExamples";
    public static final String AI_CONSTRAINTS = "aiConstraints";
    public static final String AI_EXTENSION_GUIDANCE = "aiExtensionGuidance";
    public static final String AI_CROSS_LANGUAGE_INFO = "aiCrossLanguageInfo";

    public MetaDataAIDocumentationGenerator() {
        log.debug("Initialized AI documentation generator with registry-based type discovery");
    }

    @Override
    protected JsonDirectWriter getWriter(MetaDataLoader loader, OutputStream os) {
        try {
            return new MetaDataAIDocumentationWriter(loader, os).withVersion(this.version).withInheritance(this.includeInheritance).withImplementationDetails(this.includeImplementationDetails).withExtensionGuidance(this.includeExtensionGuidance).withCrossLanguageInfo(this.includeCrossLanguageInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create AI documentation writer", e);
        }
    }

    public void setVersion(String version) {
        this.version = version;
        log.debug("Set documentation version to: {}", (Object)version);
    }

    public void setIncludeInheritance(boolean includeInheritance) {
        this.includeInheritance = includeInheritance;
        log.debug("Set includeInheritance to: {}", (Object)includeInheritance);
    }

    public void setIncludeImplementationDetails(boolean includeImplementationDetails) {
        this.includeImplementationDetails = includeImplementationDetails;
        log.debug("Set includeImplementationDetails to: {}", (Object)includeImplementationDetails);
    }

    public void setIncludeExtensionGuidance(boolean includeExtensionGuidance) {
        this.includeExtensionGuidance = includeExtensionGuidance;
        log.debug("Set includeExtensionGuidance to: {}", (Object)includeExtensionGuidance);
    }

    public void setIncludeCrossLanguageInfo(boolean includeCrossLanguageInfo) {
        this.includeCrossLanguageInfo = includeCrossLanguageInfo;
        log.debug("Set includeCrossLanguageInfo to: {}", (Object)includeCrossLanguageInfo);
    }

    @Override
    public String toString() {
        return "MetaDataAIDocumentationGenerator{version='" + this.version + "', includeInheritance=" + this.includeInheritance + ", includeImplementation=" + this.includeImplementationDetails + ", includeExtension=" + this.includeExtensionGuidance + ", includeCrossLang=" + this.includeCrossLanguageInfo + "}";
    }

    public String getConfigurationSummary() {
        StringBuilder summary = new StringBuilder();
        summary.append("AI Documentation Generator Configuration:\n");
        summary.append("  Version: ").append(this.version).append("\n");
        summary.append("  Inheritance Analysis: ").append(this.includeInheritance ? "Enabled" : "Disabled").append("\n");
        summary.append("  Implementation Details: ").append(this.includeImplementationDetails ? "Enabled" : "Disabled").append("\n");
        summary.append("  Extension Guidance: ").append(this.includeExtensionGuidance ? "Enabled" : "Disabled").append("\n");
        summary.append("  Cross-Language Info: ").append(this.includeCrossLanguageInfo ? "Enabled" : "Disabled");
        return summary.toString();
    }

    public static void registerAIDocAttributes(MetaDataRegistry registry) {
        registry.findType("object", "base").optionalAttribute(AI_VERSION, "string").optionalAttribute(AI_DESCRIPTION, "string").optionalAttribute(AI_BUSINESS_RULE, "string").optionalAttribute(AI_USAGE_CONTEXT, "string").optionalAttribute(AI_EXTENSION_GUIDANCE, "string").optionalAttribute(AI_CROSS_LANGUAGE_INFO, "string");
        registry.findType("object", "pojo").optionalAttribute(AI_DESCRIPTION, "string").optionalAttribute(AI_BUSINESS_RULE, "string");
        registry.findType("field", "base").optionalAttribute(AI_DESCRIPTION, "string").optionalAttribute(AI_BUSINESS_RULE, "string").optionalAttribute(AI_USAGE_CONTEXT, "string").optionalAttribute(AI_VALIDATION_RULES, "string").optionalAttribute(AI_EXAMPLES, "string").optionalAttribute(AI_CONSTRAINTS, "string");
        registry.findType("field", "string").optionalAttribute(AI_EXAMPLES, "string").optionalAttribute(AI_VALIDATION_RULES, "string");
        registry.findType("field", "int").optionalAttribute(AI_CONSTRAINTS, "string").optionalAttribute(AI_EXAMPLES, "string");
    }
}

