/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ServletModule;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.HttpServer;
import com.nesscomputing.httpserver.HttpServerConfig;
import com.nesscomputing.httpserver.InvalidRequestServlet;
import com.nesscomputing.httpserver.log.LogFieldsModule;
import com.nesscomputing.httpserver.log.file.FileRequestLogModule;
import com.nesscomputing.httpserver.log.log4j.Log4jRequestLogModule;
import com.nesscomputing.httpserver.log.syslog.SyslogRequestLogModule;
import java.lang.annotation.Annotation;
import javax.servlet.Servlet;

public class HttpServerModule
extends ServletModule {
    public static final String CONTEXT_PATH_NAME = "_contextPath";
    private final Config config;

    public HttpServerModule(Config config) {
        this.config = config;
    }

    public void configureServlets() {
        HttpServerConfig httpServerConfig = (HttpServerConfig)this.config.getBean(HttpServerConfig.class);
        this.bind(HttpServerConfig.class).toInstance((Object)httpServerConfig);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)CONTEXT_PATH_NAME)).to("");
        this.install((Module)new LogFieldsModule());
        this.install((Module)new FileRequestLogModule(this.config));
        this.install((Module)new Log4jRequestLogModule(this.config));
        this.install((Module)new SyslogRequestLogModule(this.config));
        Class<? extends HttpServer> serverClass = httpServerConfig.getServerClass();
        this.bind(serverClass).asEagerSingleton();
        this.bind(HttpServer.class).to(serverClass).asEagerSingleton();
        this.bind(Servlet.class).to(InvalidRequestServlet.class).in(Scopes.SINGLETON);
        this.bind(GuiceFilter.class).in(Scopes.SINGLETON);
    }
}

