/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.syslog;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.HttpServerHandlerBinder;
import com.nesscomputing.httpserver.log.syslog.SyslogRequestLog;
import com.nesscomputing.httpserver.log.syslog.SyslogRequestLogConfig;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.handler.RequestLogHandler;

public class SyslogRequestLogModule
extends AbstractModule {
    private final Config config;

    public SyslogRequestLogModule(Config config) {
        this.config = config;
    }

    public void configure() {
        SyslogRequestLogConfig syslogRequestLogConfig = (SyslogRequestLogConfig)this.config.getBean("ness.httpserver.request-log.syslog", SyslogRequestLogConfig.class);
        if (syslogRequestLogConfig.isEnabled()) {
            this.bind(SyslogRequestLogConfig.class).toInstance((Object)syslogRequestLogConfig);
            this.bind(SyslogRequestLog.class).in(Scopes.SINGLETON);
            HttpServerHandlerBinder.bindHandler(this.binder()).toProvider(HandlerProvider.class);
        }
    }

    public static class HandlerProvider
    implements Provider<RequestLogHandler> {
        private final SyslogRequestLog syslogRequestLog;

        @Inject
        public HandlerProvider(SyslogRequestLog syslogRequestLog) {
            this.syslogRequestLog = syslogRequestLog;
        }

        public RequestLogHandler get() {
            RequestLogHandler handler = new RequestLogHandler();
            handler.setRequestLog((RequestLog)this.syslogRequestLog);
            return handler;
        }
    }
}

