/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.guice.HttpClientModule;
import com.nesscomputing.httpclient.response.StringContentConverter;
import com.nesscomputing.httpserver.HttpServerHandlerBinder;
import com.nesscomputing.httpserver.HttpServerModule;
import com.nesscomputing.httpserver.jetty.ClasspathResourceHandler;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleModule;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:0"})
public class TestSoloJetty8HttpServer {
    @Inject
    @Named(value="test")
    private final HttpClient httpClient = null;
    @Inject
    private Lifecycle lifecycle = null;

    private String[] createServer(int ... port) throws Exception {
        String[] uris = new String[port.length];
        for (int i = 0; i < port.length; ++i) {
            Assert.assertFalse((port[i] == 0 ? 1 : 0) != 0);
            uris[i] = String.format("http://localhost:%d/foobar", port[i]);
        }
        return this.createServer(uris);
    }

    private String[] createServer(String ... uris) {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.service-uri", StringUtils.join((Object[])uris, (String)","), "ness.httpserver.class", "com.nesscomputing.httpserver.SoloJetty8HttpServer", "ness.httpserver.ssl-keystore", Resources.getResource(this.getClass(), (String)"/ssl-server-keystore.jks").toString(), "ness.httpclient.ssl.truststore", Resources.getResource(this.getClass(), (String)"/test-httpclient-keystore.jks").toString(), "ness.httpclient.ssl.truststore.password", "verysecret"});
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigModule(config), new HttpServerModule(config), new HttpClientModule("test"), new LifecycleModule(), new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
                HttpServerHandlerBinder.bindHandler((Binder)binder).toInstance((Object)new ClasspathResourceHandler("/foobar", "/test-resources"));
            }
        }});
        injector.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.lifecycle);
        this.lifecycle.executeTo(LifecycleStage.START_STAGE);
        return uris;
    }

    @After
    public void tearDown() throws Exception {
        Assert.assertNotNull((Object)this.lifecycle);
        this.lifecycle.executeTo(LifecycleStage.STOP_STAGE);
    }

    @Test
    public void testSimple() throws Exception {
        String baseUri = this.createServer(TestSoloJetty8HttpServer.findUnusedPort())[0];
        String content = (String)this.httpClient.get(baseUri + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
    }

    @Test
    public void testTwoUrisOneServer() throws Exception {
        String[] baseUris = this.createServer(TestSoloJetty8HttpServer.findUnusedPort(), TestSoloJetty8HttpServer.findUnusedPort());
        for (int i = 0; i < baseUris.length; ++i) {
            String content = (String)this.httpClient.get(baseUris[i] + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
            Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
        }
    }

    @Test
    public void testDoubleWhammy() throws Exception {
        int port = TestSoloJetty8HttpServer.findUnusedPort();
        String[] baseUris = this.createServer(port, port);
        for (int i = 0; i < baseUris.length; ++i) {
            String content = (String)this.httpClient.get(baseUris[i] + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
            Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
        }
    }

    @Test
    public void testYesWeCanHttps() throws Exception {
        String[] baseUris = this.createServer(String.format("http://localhost:%d/foobar", TestSoloJetty8HttpServer.findUnusedPort()), String.format("https://localhost:%d/foobar", TestSoloJetty8HttpServer.findUnusedPort()));
        for (int i = 0; i < baseUris.length; ++i) {
            String content = (String)this.httpClient.get(baseUris[i] + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
            Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findUnusedPort() throws IOException {
        int port;
        ServerSocket socket = new ServerSocket();
        try {
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        finally {
            socket.close();
        }
        return port;
    }
}

